package w83b.w83bDAO;

import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bAgrupacionesBean;
import w83b.w83bBeans.W83bArbitrosBean;
import w83b.w83bBeans.W83bCentroTrabajoBean;
import w83b.w83bBeans.W83bCentroTrabajoCompletoBean;
import w83b.w83bBeans.W83bConveniosBean;
import w83b.w83bBeans.W83bDelegacionesBean;
import w83b.w83bBeans.W83bEmpresasBean;
import w83b.w83bBeans.W83bMantenimientoDelegadosBean;
import w83b.w83bBeans.W83bMotivosBajaActaBean;
import w83b.w83bBeans.W83bMotivosBajaDelegadoBean;
import w83b.w83bBeans.W83bPlantillasBean;
import w83b.w83bBeans.W83bRespAreaBean;
import w83b.w83bBeans.W83bSindicatosBean;
import w83b.w83bBeans.W83bTiposVocesBean;
import w83b.w83bBeans.W83bTramitesBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bBeans.W83bUsuariosBean;
import w83b.w83bBeans.W83bVocesBean;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bAgrupacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bAgrupacionesConvenioBD;
import w83b.w83bDAO.w83bConstantesBD.W83bArbitrosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCentroTrabajoBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCentroTrabajoCompletoVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCentroTrabajoVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCnaeVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bComarcaVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bConveniosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bDelegacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bDelegadosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bDiferenciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bEscrutiniosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bFasesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesSindicatosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMotivosBajaActaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMotivosBajaDelegadoBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMunicipiosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPlantillasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPreavisosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bProvinciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bRespAreaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bRolBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindCitacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindPreOrigBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindicatosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindicatosPreavisosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bTipoEmpresaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bTiposVocesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bTramitesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bUsuariosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bVocesBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bMantenimientosDAO.
 * 
 * @author a
 */
public class W83bMantenimientosDAO implements W83bIMantenimientosDAO {

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public java.util.List buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bAgrupacionesBD.codigo).append(", ");
		strSql.append(W83bAgrupacionesBD.descripcion).append(", ");
		strSql.append(W83bAgrupacionesBD.descripcion_euskera).append(", ");
		strSql.append(W83bAgrupacionesBD.baja);

		strSql.append(" FROM ").append(W83bAgrupacionesBD.agrupacionesTable);

		strSql.append(" WHERE ").append(W83bAgrupacionesBD.codigo).append(" > 0 ");
		if (StringUtils.isNotEmpty(param.getCodAgrupaciones())) {
			strSql.append(" AND ").append(W83bAgrupacionesBD.codigo).append(" = ? ");
			params.add(new Integer(param.getCodAgrupaciones()));
		}
		if (StringUtils.isNotEmpty(param.getDescAgrupaciones())) {
			strSql.append(" AND UPPER(").append(W83bAgrupacionesBD.descripcion).append(") LIKE ? ");
			params.add(new StringBuffer().append("%").append(param.getDescAgrupaciones().toUpperCase()).append("%").toString());
		}
		if (StringUtils.isNotEmpty(param.getDescAgrupacionesEusk())) {
			strSql.append(" AND UPPER(").append(W83bAgrupacionesBD.descripcion_euskera).append(") LIKE ? ");
			params.add(new StringBuffer().append("%").append(param.getDescAgrupacionesEusk().toUpperCase()).append("%").toString());
		}
		if (StringUtils.isNotEmpty(param.getBaja())) {
			strSql.append(" AND ").append(W83bAgrupacionesBD.baja).append(" is not null");
		} else {
			strSql.append(" AND ").append(W83bAgrupacionesBD.baja).append(" is null");
		}

		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());

		List listaAgrupaciones = W83bDataBase.executeQuery(strSql.toString(),params, W83bAgrupacionesBean.class, param.getUsuarioBean(),null);

		return listaAgrupaciones;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public java.util.List buscarConvenioPorAgrupacion(w83b.w83bBeans.W83bAgrupacionesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT T02.");
		strSql.append(W83bConveniosBD.codigo).append(", T02.");
		strSql.append(W83bConveniosBD.descripcion).append(", T02.");
		strSql.append(W83bConveniosBD.descripcion_eusk);

		strSql.append(" FROM ").append(W83bAgrupacionesConvenioBD.agrupacionesConvenioTable);
		strSql.append(" T09, ").append(W83bConveniosBD.convenioTable);
		strSql.append(" T02 ");

		strSql.append(" WHERE T09.");
		strSql.append(W83bAgrupacionesConvenioBD.codigoAgrupacion).append(" = ? ");
		params.add(new Integer(param.getCodAgrupaciones()));

		strSql.append(" AND T09.");
		strSql.append(W83bAgrupacionesConvenioBD.codigoConvenio).append(" = T02.");
		strSql.append(W83bConveniosBD.codigo);

		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());

		List listConvenios = W83bDataBase.executeQuery(strSql.toString(),params, W83bConveniosBean.class, param.getUsuarioBean(), null);

		return listConvenios;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#editarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public w83b.w83bBeans.W83bAgrupacionesBean detalleAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bAgrupacionesBD.codigo).append(", ");
		strSql.append(W83bAgrupacionesBD.descripcion).append(", ");
		strSql.append(W83bAgrupacionesBD.descripcion_euskera).append(", ");
		strSql.append(W83bAgrupacionesBD.baja);

		strSql.append(" FROM ").append(W83bAgrupacionesBD.agrupacionesTable);

		strSql.append(" WHERE ");
		strSql.append(W83bAgrupacionesBD.codigo).append(" = ? ");
		params.add(new Integer(param.getCodAgrupaciones()));

		List listaAgrupaciones = W83bDataBase.executeQuery(strSql.toString(),params, W83bAgrupacionesBean.class, param.getUsuarioBean(),null);

		return (W83bAgrupacionesBean) listaAgrupaciones.get(0);
	}

	/**
	 * Existe agrupacion.
	 * 
	 * @param codAgrupacion the cod agrupacion
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeAgrupacion(String codAgrupacion) throws Exception {StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bAgrupacionesBD.codigo);

		strSql.append(" FROM ").append(W83bAgrupacionesBD.agrupacionesTable);

		strSql.append(" WHERE ").append(W83bAgrupacionesBD.codigo).append(" = ? ");
		params.add(new Integer(codAgrupacion));

		List listaAgrupaciones = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaAgrupaciones.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#anyadirAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public String anyadirAgrupaciones(W83bAgrupacionesBean param)
			throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bAgrupacionesBD.agrupacionesTable);
		strSql.append("(");
		strSql.append(W83bAgrupacionesBD.codigo);
		strSql.append(", ");
		strSql.append(W83bAgrupacionesBD.descripcion);
		strSql.append(", ");
		strSql.append(W83bAgrupacionesBD.descripcion_euskera);
		strSql.append(", ");
		strSql.append(W83bAgrupacionesBD.baja);
		strSql.append(")");
		// strSql.append(" VALUES (?,?)");
		strSql.append(" VALUES (?,?,?,?)");

		params.add(new Integer(param.getCodAgrupaciones()));

		if (StringUtils.isNotEmpty(param.getDescAgrupaciones())) {
			params.add(param.getDescAgrupaciones().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescAgrupacionesEusk())) {
			params.add(param.getDescAgrupacionesEusk().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(W83bClsConstantes.NULL_DATE);

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#maxCodAgrupacion()
	 */
	public String maxCodAgrupacion() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT MAX(");
		strSql.append(W83bAgrupacionesBD.codigo);

		strSql.append(") FROM ").append(W83bAgrupacionesBD.agrupacionesTable);

		List listaAgrupaciones = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		return listaAgrupaciones.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#contarAgrupaciones()
	 */
	public String contarAgrupaciones() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT COUNT(");
		strSql.append(W83bAgrupacionesBD.codigo);

		strSql.append(") FROM ").append(W83bAgrupacionesBD.agrupacionesTable);

		List listaAgrupaciones = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		return listaAgrupaciones.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#anyadirAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public String modificarAgrupaciones(W83bAgrupacionesBean param)
	throws Exception {
		
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			
			strSql.append("UPDATE ");
			strSql.append(W83bAgrupacionesBD.agrupacionesTable);
			strSql.append(" SET ");
			strSql.append(W83bAgrupacionesBD.descripcion);
			strSql.append(" = ? ");
			strSql.append(", ");
			strSql.append(W83bAgrupacionesBD.descripcion_euskera);
			strSql.append(" = ? ");
			if(StringUtils.isEmpty(param.getBaja())){
				strSql.append(", ");
				strSql.append(W83bAgrupacionesBD.baja);
				strSql.append(" = ? ");
			}
			strSql.append(" WHERE ").append(W83bAgrupacionesBD.codigo).append(" = ? ");
		
			if(StringUtils.isNotEmpty(param.getDescAgrupaciones())){
				params.add(param.getDescAgrupaciones().toUpperCase());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if(StringUtils.isNotEmpty(param.getDescAgrupacionesEusk())){
				params.add(param.getDescAgrupacionesEusk().toUpperCase());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);			
			}
			if(StringUtils.isEmpty(param.getBaja())){
				params.add(W83bClsConstantes.NULL_DATE);
			}
			params.add(new Integer(param.getCodAgrupaciones()));
			
			W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());
			
			return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarAgrupaciones(java.util.ArrayList)
	 */
	public java.lang.String borrarAgrupaciones(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bAgrupacionesBD.agrupacionesTable);
		strSql.append(" SET ");
		strSql.append(W83bAgrupacionesBD.baja);
		strSql.append(" = to_Date(?,'DD/mm/YYYY') ");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		params.add(sdf.format(new Date()));

		strSql.append(" WHERE ");

		strSql.append(W83bAgrupacionesBD.codigo).append(" = ? ");
		params.add(new Integer((String) param.get(0)));
		for (int i = 1, size = param.size(); i < size; i++) {
			strSql.append(" OR ").append(W83bAgrupacionesBD.codigo).append(" = ? ");
			params.add(new Integer((String) param.get(i)));// NOPMD
		}

		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.buscarConvenios)
	 */
	public java.util.List buscarConvenios(w83b.w83bBeans.W83bConveniosBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT TCONVENIO.");
		strSql.append(W83bConveniosBD.codigo).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.descripcion).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.descripcion_eusk).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.convPorEscrut).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.espEnAlava).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.espEnBizkaia).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.espEnGuip).append(", TTIPOEMPRESA.");
		strSql.append(W83bTipoEmpresaBD.descripcion).append(", TTIPOEMPRESA.");
		strSql.append(W83bTipoEmpresaBD.descripcion_eusk).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.CMADRID_002).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.tipoEmpresa).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.baja);

		strSql.append(" FROM ").append(W83bConveniosBD.convenioTable).append(" TCONVENIO");
		strSql.append(", ").append(W83bTipoEmpresaBD.tipoEmpresaTable).append(" TTIPOEMPRESA");

		strSql.append(" WHERE TCONVENIO.").append(W83bConveniosBD.codigo).append(" > 0 ");
		if (StringUtils.isNotEmpty(param.getCodConvenios())) {
			strSql.append(" AND TCONVENIO.").append(W83bConveniosBD.codigo).append(" = ? ");
			params.add(new Integer(param.getCodConvenios()));
		}
		if (StringUtils.isNotEmpty(param.getDescConvenios())) {
			strSql.append(" AND UPPER(TCONVENIO.").append(W83bConveniosBD.descripcion).append(") LIKE ? ");
			params.add(new StringBuffer().append("%").append(param.getDescConvenios().toUpperCase()).append("%").toString());
		}
		if (StringUtils.isNotEmpty(param.getDescConveniosEusk())) {
			strSql.append(" AND UPPER(TCONVENIO.").append(W83bConveniosBD.descripcion_eusk).append(") LIKE ? ");
			params.add(new StringBuffer().append("%").append(param.getDescConveniosEusk().toUpperCase()).append("%").toString());
		}
		if (StringUtils.isNotEmpty(param.getConvPorEscrut())) {
			strSql.append(" AND TCONVENIO.").append(W83bConveniosBD.convPorEscrut).append(" = ? ");
			params.add(param.getConvPorEscrut());
		}
		if (StringUtils.isNotEmpty(param.getEspEnAlava())) {
			strSql.append(" AND TCONVENIO.").append(W83bConveniosBD.espEnAlava).append(" = ? ");
			params.add(param.getEspEnAlava());
		}
		if (StringUtils.isNotEmpty(param.getEspEnBizkaia())) {
			strSql.append(" AND TCONVENIO.").append(W83bConveniosBD.espEnBizkaia).append(" = ? ");
			params.add(param.getEspEnBizkaia());
		}
		if (StringUtils.isNotEmpty(param.getEspEnGuip())) {
			strSql.append(" AND TCONVENIO.").append(W83bConveniosBD.espEnGuip).append(" = ? ");
			params.add(param.getEspEnGuip());
		}
		if (StringUtils.isNotEmpty(param.getTipoEmpresa())) {
			strSql.append(" AND TCONVENIO.").append(W83bConveniosBD.tipoEmpresa).append(" = ? ");
			params.add(new Integer(param.getTipoEmpresa()));
		}
		if (StringUtils.isNotEmpty(param.getCodMadrid())) {
			strSql.append(" AND TCONVENIO.").append(W83bConveniosBD.CMADRID_002).append(" = ? ");
			params.add(param.getCodMadrid());
		}
		if (StringUtils.isNotEmpty(param.getBaja())) {
			strSql.append(" AND ").append(W83bConveniosBD.baja).append(" is not null");
		} else {
			strSql.append(" AND ").append(W83bConveniosBD.baja).append(" is null");
		}

		strSql.append(" AND TTIPOEMPRESA.").append(W83bTipoEmpresaBD.codigo).append(" = TCONVENIO.");
		strSql.append(W83bConveniosBD.tipoEmpresa);

		String sort = "TCONVENIO.";

		if (param.getIdColumna().equals(W83bTipoEmpresaBD.descripcion)|| param.getIdColumna().equals(W83bTipoEmpresaBD.descripcion_eusk)) {
			sort = "TTIPOEMPRESA.";
		}

		strSql.append(" ORDER BY ").append(sort).append(param.getIdColumna()).append(" ").append(param.getSort());

		List listaConvenios = W83bDataBase.executeQuery(strSql.toString(),params, W83bConveniosBean.class, param.getUsuarioBean(), param.getIdioma());

		return listaConvenios;
	}

	/**
	 * Existe convenio.
	 * 
	 * @param param  the param
	 * @return true, if successful
	 * @throws Exception  the exception
	 */
	public boolean existeConvenio(String param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bConveniosBD.codigo);

		strSql.append(" FROM ").append(W83bConveniosBD.convenioTable);

		strSql.append(" WHERE ").append(W83bConveniosBD.codigo).append(" = ? ");
		params.add(new Integer(param));

		List listaConvenios = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaConvenios.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#anyadirConvenios(w83b.w83bBeans.W83bConveniosBean)
	 */
	public String anyadirConvenios(W83bConveniosBean param) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bConveniosBD.convenioTable);
		strSql.append("(");
		strSql.append(W83bConveniosBD.codigo);
		strSql.append(", ");
		strSql.append(W83bConveniosBD.descripcion);
		strSql.append(", ");
		strSql.append(W83bConveniosBD.descripcion_eusk);
		strSql.append(", ");
		strSql.append(W83bConveniosBD.convPorEscrut);
		strSql.append(", ");
		strSql.append(W83bConveniosBD.espEnAlava);
		strSql.append(", ");
		strSql.append(W83bConveniosBD.espEnGuip);
		strSql.append(", ");
		strSql.append(W83bConveniosBD.espEnBizkaia);
		strSql.append(", ");
		strSql.append(W83bConveniosBD.CMADRID_002);
		strSql.append(", ");
		strSql.append(W83bConveniosBD.tipoEmpresa);
		strSql.append(", ");
		strSql.append(W83bConveniosBD.baja);
		strSql.append(")");

		strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,?)");

		params.add(new Integer(param.getCodConvenios()));

		if (StringUtils.isNotEmpty(param.getDescConvenios())) {
			params.add(param.getDescConvenios().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}

		if (StringUtils.isNotEmpty(param.getDescConveniosEusk())) {
			params.add(param.getDescConveniosEusk().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}

		params.add(param.getConvPorEscrut());
		params.add(param.getEspEnAlava());
		params.add(param.getEspEnGuip());
		params.add(param.getEspEnBizkaia());

		params.add(param.getCodMadrid());

		params.add(new Integer(param.getTipoEmpresa()));
		params.add(W83bClsConstantes.NULL_DATE);

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#maxCodConvenios()
	 */
	public String maxCodConvenios() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT MAX(");
		strSql.append(W83bConveniosBD.codigo);

		strSql.append(") FROM ").append(W83bConveniosBD.convenioTable);

		List listaAgrupaciones = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		return listaAgrupaciones.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#contarConvenios()
	 */
	public String contarConvenios() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT COUNT(");
		strSql.append(W83bConveniosBD.codigo);

		strSql.append(") FROM ").append(W83bConveniosBD.convenioTable);

		List listaAgrupaciones = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		return listaAgrupaciones.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#editarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public w83b.w83bBeans.W83bConveniosBean detalleConvenios(w83b.w83bBeans.W83bConveniosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT TCONVENIO.");
		strSql.append(W83bConveniosBD.codigo).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.descripcion).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.descripcion_eusk).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.convPorEscrut).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.espEnAlava).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.espEnBizkaia).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.espEnGuip).append(", TTIPOEMPRESA.");
		strSql.append(W83bTipoEmpresaBD.codigo).append(", TTIPOEMPRESA.");
		strSql.append(W83bTipoEmpresaBD.descripcion).append(", TTIPOEMPRESA.");
		strSql.append(W83bTipoEmpresaBD.descripcion_eusk).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.descripcion_eusk).append(", TCONVENIO.");
		strSql.append(W83bConveniosBD.CMADRID_002);
		//20150430 obteniendo la fecha de baja dependiendo del idioma
		strSql.append(", to_char(TCONVENIO.").append(W83bConveniosBD.baja).append(",?) as ").append("").append(W83bConveniosBD.baja);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(" FROM ").append(W83bConveniosBD.convenioTable).append(" TCONVENIO");
		strSql.append(", ").append(W83bTipoEmpresaBD.tipoEmpresaTable).append(" TTIPOEMPRESA");

		strSql.append(" WHERE ");
		strSql.append(" TCONVENIO.").append(W83bConveniosBD.codigo).append(" = ? ");
		params.add(new Integer(param.getCodConvenios()));

		strSql.append(" AND TTIPOEMPRESA.").append(W83bTipoEmpresaBD.codigo).append(" = TCONVENIO.");
		strSql.append(W83bConveniosBD.tipoEmpresa);

		List listaConvenios = W83bDataBase.executeQuery(strSql.toString(),params, W83bConveniosBean.class, param.getUsuarioBean(), param.getIdioma());

		return (W83bConveniosBean) listaConvenios.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#anyadirAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public String modificarConvenios(W83bConveniosBean param) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bConveniosBD.convenioTable);
		strSql.append(" SET ");
		strSql.append(W83bConveniosBD.descripcion);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bConveniosBD.descripcion_eusk);
		strSql.append(" = ? ");
//		20150430 se aade la fecha de baja
		strSql.append(", ");
		strSql.append(W83bConveniosBD.baja);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bConveniosBD.CMADRID_002);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bConveniosBD.convPorEscrut);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bConveniosBD.espEnAlava);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bConveniosBD.espEnBizkaia);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bConveniosBD.espEnGuip);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bConveniosBD.tipoEmpresa);
		strSql.append(" = ? ");

		strSql.append(" WHERE ").append(W83bConveniosBD.codigo).append(" = ? ");

		if (StringUtils.isNotEmpty(param.getDescConvenios())) {
			params.add(param.getDescConvenios().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescConveniosEusk())) {
			params.add(param.getDescConveniosEusk().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isEmpty(param.getFechaBaja())) {
			params.add(W83bClsConstantes.NULL_DATE);
		}
		//20150430 se aade la fecha de baja
		else{
			params.add(param.getFechaBaja());
		}
		params.add(param.getCodMadrid());
		params.add(param.getConvPorEscrut());
		params.add(param.getEspEnAlava());
		params.add(param.getEspEnBizkaia());
		params.add(param.getEspEnGuip());
		params.add(param.getTipoEmpresa());
		params.add(new Integer(param.getCodConvenios()));

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarAgrupaciones(java.util.ArrayList)
	 */
	/**
	 * Borrar convenios_old.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String borrarConvenios_old(java.util.ArrayList param)throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bConveniosBD.convenioTable);
		strSql.append(" WHERE ");

		strSql.append(W83bConveniosBD.codigo).append(" = ? ");
		params.add(new Integer((String) param.get(0)));
		for (int i = 1, size = param.size(); i < size; i++) {
			strSql.append(" OR ").append(W83bConveniosBD.codigo).append(" = ? ");
			params.add(new Integer((String) param.get(i)));// NOPMD
		}

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarAgrupaciones(java.util.ArrayList)
	 */
	public java.lang.String borrarConveniosIndividual(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bConveniosBD.convenioTable);
		strSql.append(" SET ");
		strSql.append(W83bConveniosBD.baja);
		strSql.append(" = to_Date(?,'DD/mm/YYYY') ");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		params.add(sdf.format(new Date()));

		strSql.append(" WHERE ");

		strSql.append(W83bConveniosBD.codigo).append(" = ? ");
		params.add(new Integer(param));

		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarAgrupaciones(java.util.ArrayList)
	 */
	public java.lang.String borrarConvenios(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bConveniosBD.convenioTable);
		strSql.append(" SET ");
		strSql.append(W83bConveniosBD.baja);

		strSql.append(" = to_Date(?,'DD/mm/YYYY') ");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		params.add(sdf.format(new Date()));
		strSql.append(" WHERE ");

		strSql.append(W83bConveniosBD.codigo).append(" = ? ");
		params.add(new Integer((String) param.get(0)));
		for (int i = 1, size = param.size(); i < size; i++) {
			strSql.append(" OR ").append(W83bConveniosBD.codigo).append(" = ? ");
			params.add(new Integer((String) param.get(i)));// NOPMD
		}

		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarAgrupaciones(java.util.ArrayList)
	 */
	public java.lang.String borrarConveniosAgrupacion(java.util.ArrayList param, W83bUsuarioXLNetsBean usuarioBean)throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bAgrupacionesConvenioBD.agrupacionesConvenioTable);
		strSql.append(" WHERE ");

		strSql.append(W83bAgrupacionesConvenioBD.codigoConvenio).append(" = ? ");
		params.add(new Integer((String) param.get(0)));
		for (int i = 1, size = param.size(); i < size; i++) {
			strSql.append(" OR ").append(W83bAgrupacionesConvenioBD.codigoConvenio).append(" = ? ");
			params.add(new Integer((String) param.get(i)));// NOPMD
		}

		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarAgrupaciones(java.util.ArrayList)
	 */
	public java.lang.String borrarConveniosAgrupacionCodAgrupacion(java.util.ArrayList param, W83bUsuarioXLNetsBean usuarioBean)throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bAgrupacionesConvenioBD.agrupacionesConvenioTable);
		strSql.append(" WHERE ");

		strSql.append(W83bAgrupacionesConvenioBD.codigoAgrupacion).append(" = ? ");
		params.add(new Integer((String) param.get(0)));
		for (int i = 1, size = param.size(); i < size; i++) {
			strSql.append(" OR ").append(W83bAgrupacionesConvenioBD.codigoAgrupacion).append(" = ? ");
			params.add(new Integer((String) param.get(i)));// NOPMD
		}

		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarAgrupaciones(java.util.ArrayList)
	 */
	public java.lang.String asociarConvenios(String idConvenio,String idAgrupacion, W83bUsuarioXLNetsBean usuarioBean)throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bAgrupacionesConvenioBD.agrupacionesConvenioTable);
		strSql.append("( ");
		strSql.append(W83bAgrupacionesConvenioBD.codigoAgrupacion);
		strSql.append(", ");
		strSql.append(W83bAgrupacionesConvenioBD.codigoConvenio);
		strSql.append(") ");

		strSql.append(" VALUES (?,?)");

		params.add(new Integer(idAgrupacion));
		params.add(new Integer(idConvenio));

		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/**
	 * Existe convenio agrupacion.
	 * 
	 * @param idConvenio the id convenio
	 * @param idAgrupacion the id agrupacion
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenioAgrupacion(String idConvenio,String idAgrupacion) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bAgrupacionesConvenioBD.codigoAgrupacion);

		strSql.append(" FROM ").append(W83bAgrupacionesConvenioBD.agrupacionesConvenioTable);

		strSql.append(" WHERE ").append(W83bAgrupacionesConvenioBD.codigoAgrupacion).append(" = ? ");
		params.add(new Integer(idAgrupacion));
		strSql.append(" AND ").append(W83bAgrupacionesConvenioBD.codigoConvenio).append(" = ? ");
		params.add(new Integer(idConvenio));

		List listaConvenios = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaConvenios.size() > 0) {
			return true;
		}

		return false;
	}

	/**
	 * Existe convenio agrupacion 2.
	 * 
	 * @param idConvenio the id convenio
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenioAgrupacion2(String idConvenio)
			throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bAgrupacionesConvenioBD.codigoAgrupacion);

		strSql.append(" FROM ").append(W83bAgrupacionesConvenioBD.agrupacionesConvenioTable);

		strSql.append(" WHERE ").append(W83bAgrupacionesConvenioBD.codigoConvenio).append(" = ? ");
		params.add(new Integer(idConvenio));

		List listaConvenios = W83bDataBase.executeSimpleQuery(
				strSql.toString(), params, null);

		if (listaConvenios.size() > 0) {
			return true;
		}
		return false;
	}

	/**
	 * Existe convenio agrupacion.
	 * 
	 * @param idCodigo the id codigo
	 * @param codConvenio the cod convenio
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenioAgrupacion(String idCodigo, boolean codConvenio)
			throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bAgrupacionesConvenioBD.codigoAgrupacion);

		strSql.append(" FROM ").append(
				W83bAgrupacionesConvenioBD.agrupacionesConvenioTable);

		if (codConvenio) {
			strSql.append(" WHERE ").append(W83bAgrupacionesConvenioBD.codigoConvenio).append(" = ? ");
			params.add(new Integer(idCodigo));
		} else {
			strSql.append(" WHERE ").append(W83bAgrupacionesConvenioBD.codigoAgrupacion).append(" = ? ");
			params.add(new Integer(idCodigo));
		}

		List listaConvenios = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaConvenios.size() > 0) {
			return true;
		}

		return false;
	}

	/**
	 * Existe convenio actas.
	 * 
	 * @param idCodigo the id codigo
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenioActas(String idCodigo) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bActasBD.codConvenio);

		strSql.append(" FROM ").append(W83bActasBD.actasTable);

		strSql.append(" WHERE ").append(W83bActasBD.codConvenio)
				.append(" = ? ");
		params.add(new Integer(idCodigo));

		List listaConvenios = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaConvenios.size() > 0) {
			return true;
		}

		return false;
	}

	/**
	 * Existe convenio preavisos.
	 * 
	 * @param idCodigo the id codigo
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenioPreavisos(String idCodigo) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.c_conv_037);

		strSql.append(" FROM ").append(W83bPreavisosBD.preavisosTable);

		strSql.append(" WHERE ").append(W83bPreavisosBD.c_conv_037).append(
				" = ? ");
		params.add(new Integer(idCodigo));

		List listaConvenios = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaConvenios.size() > 0) {
			return true;
		}

		return false;
	}

	/**
	 * Existe convenio preavisos53.
	 * 
	 * @param idCodigo the id codigo
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeConvenioPreavisos53(String idCodigo) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.c_conv_053);

		strSql.append(" FROM ").append(
				W83bPreavisosBD.preavisos_originalesTable);

		strSql.append(" WHERE ").append(W83bPreavisosBD.c_conv_053).append(" = ? ");
		params.add(new Integer(idCodigo));

		List listaConvenios = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaConvenios.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#buscarSindicatos(w83b.w83bBeans.
	 * W83bSindicatosBean)
	 */
	public java.util.List buscarSindicatos(w83b.w83bBeans.W83bSindicatosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bSindicatosBD.codSindicato).append(", ");
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma())) {
			strSql.append(W83bSindicatosBD.descSindicatoCast).append(" AS " + W83bSindicatosBD.descSindicato + ", ");
		} else {
			strSql.append(W83bSindicatosBD.descSindicatoEusk).append(" AS " + W83bSindicatosBD.descSindicato + ", ");
		}
		strSql.append(W83bSindicatosBD.descSindicatoCast).append(", ");
		strSql.append(W83bSindicatosBD.descSindicatoEusk).append(", ");
		strSql.append(W83bSindicatosBD.siglas).append(", ");
		strSql.append(W83bSindicatosBD.codVerificacion).append(", ");
		strSql.append(W83bSindicatosBD.codMadrid).append(", ");
		strSql.append(W83bSindicatosBD.stes);

		strSql.append(" FROM ").append(W83bSindicatosBD.sindicatosVista);

		strSql.append(" WHERE ").append(W83bSindicatosBD.codSindicato).append(" > 0 ");
		if (StringUtils.isNotEmpty(param.getCodSindicato())) {
			strSql.append(" AND ").append(W83bSindicatosBD.codSindicato).append(" = ? ");
			params.add(new Integer(param.getCodSindicato()));
		}
		if (StringUtils.isNotEmpty(param.getDescSindicatoCast())) {
			strSql.append(" AND ").append(W83bSindicatosBD.descSindicatoCast).append(" LIKE ? ");
			params.add("%" + param.getDescSindicatoCast().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getDescSindicatoEusk())) {
			strSql.append(" AND ").append(W83bSindicatosBD.descSindicatoEusk).append(" LIKE ? ");
			params.add("%" + param.getDescSindicatoEusk().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getSiglas())) {
			strSql.append(" AND ").append(W83bSindicatosBD.siglas).append(" LIKE ? ");
			params.add("%" + param.getSiglas().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getCodVerificacion())) {
			strSql.append(" AND ").append(W83bSindicatosBD.codVerificacion).append(" = ? ");
			params.add(param.getCodVerificacion().toUpperCase());
		}
		if (StringUtils.isNotEmpty(param.getCodMadrid())) {
			strSql.append(" AND ").append(W83bSindicatosBD.codMadrid).append(" = ? ");
			params.add(param.getCodMadrid().toUpperCase());
		}
		/*
		 * if(StringUtils.isNotEmpty(param.getStes())){
		 * strSql.append(" AND ").append(W83bSindicatosBD.stes).append(" = ? ");
		 * params.add(param.getStes().toUpperCase()); }
		 */
		if (StringUtils.isNotEmpty(param.getBaja())) {
			strSql.append(" AND ").append(W83bSindicatosBD.baja).append(" IS NOT NULL ");
		} else {
			strSql.append(" AND ").append(W83bSindicatosBD.baja).append(" IS NULL ");
		}

		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());

		List listaSindicatos = W83bDataBase.executeQuery(strSql.toString(),params, W83bSindicatosBean.class, param.getUsuarioBean(), null);

		return listaSindicatos;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarSindicatos(java.util.ArrayList,w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public java.lang.String borrarSindicatos(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bSindicatosBD.sindicatosVista);
		strSql.append(" SET ");
		strSql.append(W83bSindicatosBD.baja);

		strSql.append(" = to_Date(?,'DD/mm/YYYY') ");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		params.add(sdf.format(new Date()));
		strSql.append(" WHERE ");

		strSql.append(W83bSindicatosBD.codSindicato).append(" IN (");

		for (int i = 0; i < param.size(); i++) {
			if (i > 0) {
				strSql.append(",");
			}
			strSql.append("?");
			params.add(param.get(i));
		}

		strSql.append(")");

		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#maxCodSindicato()
	 */
	public String maxCodSindicato() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT NVL(MAX(");
		strSql.append(W83bSindicatosBD.codSindicato);

		strSql.append("),0) FROM ").append(W83bSindicatosBD.sindicatosVista);

		List listaSindicatos = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		return listaSindicatos.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#contarSindicatos()
	 */
	public String contarSindicatos() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT COUNT(");
		strSql.append(W83bSindicatosBD.codSindicato);

		strSql.append(") FROM ").append(W83bSindicatosBD.sindicatosVista);

		List listaSindicatos = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		return listaSindicatos.get(0).toString();
	}

	/**
	 * Existe sindicato.
	 * 
	 * @param codSindicato the cod sindicato
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeSindicato(String codSindicato) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bSindicatosBD.codSindicato);

		strSql.append(" FROM ").append(W83bSindicatosBD.sindicatosVista);

		strSql.append(" WHERE ").append(W83bSindicatosBD.codSindicato).append(" = ? ");
		params.add(new Integer(codSindicato));

		List listaSindicatos = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaSindicatos.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#anyadirAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public String anyadirSindicato(w83b.w83bBeans.W83bSindicatosBean param)throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bSindicatosBD.sindicatosVista);
		strSql.append("(");
		strSql.append(W83bSindicatosBD.codSindicato);
		strSql.append(",");
		strSql.append(W83bSindicatosBD.descSindicatoCast);
		strSql.append(",");
		strSql.append(W83bSindicatosBD.siglas);
		strSql.append(",");
		strSql.append(W83bSindicatosBD.codVerificacion);
		strSql.append(",");
		strSql.append(W83bSindicatosBD.codMadrid);
		strSql.append(",");
		strSql.append(W83bSindicatosBD.stes);
		strSql.append(",");
		strSql.append(W83bSindicatosBD.descSindicatoEusk);
		strSql.append(",");
		strSql.append(W83bSindicatosBD.baja);
		strSql.append(",");
		strSql.append(W83bSindicatosBD.direccion);
		strSql.append(",");
		strSql.append(W83bSindicatosBD.cp);
		strSql.append(",");
		strSql.append(W83bSindicatosBD.municipio);
		strSql.append(",");
		strSql.append(W83bSindicatosBD.provincia);
		strSql.append(") VALUES (?,UPPER(?),UPPER(?),?,UPPER(?),UPPER(?),UPPER(?),?,UPPER(?),?,?,?)");

		params.add(new Integer(param.getCodSindicato()));

		if (StringUtils.isNotEmpty(param.getDescSindicatoCast())) {
			params.add(param.getDescSindicatoCast());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getSiglas())) {
			params.add(param.getSiglas());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCodVerificacion())) {
			params.add(param.getCodVerificacion());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCodMadrid())) {
			params.add(param.getCodMadrid());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getStes())) {
			params.add(param.getStes());
		}
		if (StringUtils.isNotEmpty(param.getDescSindicatoEusk())) {
			params.add(param.getDescSindicatoEusk());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(W83bClsConstantes.NULL_STRING);
		if (StringUtils.isNotEmpty(param.getDireccion())) {
			params.add(param.getDireccion());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCp())) {
			params.add(param.getCp());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getMunicipio())) {
			params.add(param.getMunicipio());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getProvincia())) {
			params.add(param.getProvincia());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#editarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public w83b.w83bBeans.W83bSindicatosBean detalleSindicatos(w83b.w83bBeans.W83bSindicatosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bSindicatosBD.codSindicato).append(", ");
		strSql.append(W83bSindicatosBD.descSindicatoCast).append(", ");
		strSql.append(W83bSindicatosBD.descSindicatoEusk).append(", ");
		strSql.append(W83bSindicatosBD.siglas).append(", ");
		strSql.append(W83bSindicatosBD.codVerificacion).append(", ");
		strSql.append(W83bSindicatosBD.codMadrid).append(", ");
		strSql.append(W83bSindicatosBD.stes).append(", ");
		strSql.append(W83bSindicatosBD.baja).append(", ");
		strSql.append(W83bSindicatosBD.direccion).append(", ");
		strSql.append(W83bSindicatosBD.cp).append(", ");
		strSql.append(W83bSindicatosBD.municipio).append(", ");
		strSql.append(W83bSindicatosBD.provincia);

		strSql.append(" FROM ").append(W83bSindicatosBD.sindicatosVista);

		strSql.append(" WHERE ");
		strSql.append(W83bSindicatosBD.codSindicato).append(" = ? ");
		params.add(new Integer(param.getCodSindicato()));

		List listaSindicatos = W83bDataBase.executeQuery(strSql.toString(),params, W83bSindicatosBean.class, param.getUsuarioBean(), null);

		return (W83bSindicatosBean) listaSindicatos.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#modificarSindicatos(w83b.w83bBeans.W83bSindicatosBean)
	 */
	public String modificarSindicatos(W83bSindicatosBean param)throws Exception {
		Calendar c = new GregorianCalendar();

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bSindicatosBD.sindicatosVista);
		strSql.append(" SET ");
		strSql.append(W83bSindicatosBD.descSindicatoCast);
		strSql.append(" = UPPER(?) ");
		strSql.append(", ");
		strSql.append(W83bSindicatosBD.siglas);
		strSql.append(" = UPPER(?) ");
		strSql.append(", ");
		strSql.append(W83bSindicatosBD.codVerificacion);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bSindicatosBD.codMadrid);
		strSql.append(" = UPPER(?) ");
		strSql.append(", ");
		strSql.append(W83bSindicatosBD.stes);
		strSql.append(" = UPPER(?) ");
		strSql.append(", ");
		strSql.append(W83bSindicatosBD.descSindicatoEusk);
		strSql.append(" = UPPER(?) ");
		strSql.append(", ");
		strSql.append(W83bSindicatosBD.baja);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bSindicatosBD.direccion);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bSindicatosBD.cp);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bSindicatosBD.municipio);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bSindicatosBD.provincia);
		strSql.append(" = ? ");

		strSql.append(" WHERE ").append(W83bSindicatosBD.codSindicato).append(" = ? ");

		if (StringUtils.isNotEmpty(param.getDescSindicatoCast())) {
			params.add(param.getDescSindicatoCast());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getSiglas())) {
			params.add(param.getSiglas());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCodVerificacion())) {
			params.add(param.getCodVerificacion());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCodMadrid())) {
			params.add(param.getCodMadrid());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getStes())) {
			params.add(param.getStes());
		} else {
			params.add(W83bClsConstantes.CONSTANTE_NO);
		}
		if (StringUtils.isNotEmpty(param.getDescSindicatoEusk())) {
			params.add(param.getDescSindicatoEusk());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getBaja())) {
			params.add(Integer.toString(c.get(Calendar.DATE)) + "/"
					+ Integer.toString(c.get(Calendar.MONTH)) + "/"
					+ Integer.toString(c.get(Calendar.YEAR)));
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDireccion())) {
			params.add(param.getDireccion());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCp())) {
			params.add(param.getCp());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getMunicipio())) {
			params.add(param.getMunicipio());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getProvincia())) {
			params.add(param.getProvincia());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(new Integer(param.getCodSindicato()));

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#buscarSindicatos(w83b.w83bBeans.W83bSindicatosBean)
	 */
	public java.util.List buscarUsuarios(w83b.w83bBeans.W83bUsuariosBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//		

		strSql.append("SELECT ");
		strSql.append(W83bUsuariosBD.dniUsuario).append(", ");
		strSql.append(W83bUsuariosBD.nombre).append("|| ' ' ||").append(W83bUsuariosBD.apellido1).append("|| ' ' ||").append(W83bUsuariosBD.apellido2).append(" AS ").append(W83bUsuariosBD.nombre).append(", ");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)) {
			strSql.append(W83bSindicatosBD.descSindicatoCast).append(" AS C_SINDI_001, ");
			strSql.append("ROLES.").append(W83bRolBD.descCastellano).append(" AS ROL_001, ");
			strSql.append("to_char(").append(W83bUsuariosBD.fechaAlta).append(",'").append(W83bClsConstantes.FORMATO_FECHA_CASTELLANO);
			strSql.append("')").append(" AS ").append(W83bUsuariosBD.fechaAlta).append(", ");
			strSql.append("to_char(").append(W83bUsuariosBD.fechaBaja).append(",'").append(W83bClsConstantes.FORMATO_FECHA_CASTELLANO);
			strSql.append("')").append(" AS ").append(W83bUsuariosBD.fechaBaja);

		} else {
			strSql.append(W83bSindicatosBD.descSindicatoEusk).append(" AS C_SINDI_001, ");
			strSql.append("ROLES.").append(W83bRolBD.descEuskera).append(" AS ROL_001, ");
			strSql.append("to_char(").append(W83bUsuariosBD.fechaAlta).append(",'").append(W83bClsConstantes.FORMATO_FECHA_EUSKARA);
			strSql.append("')").append(" AS ").append(W83bUsuariosBD.fechaAlta).append(", ");
			strSql.append("to_char(").append(W83bUsuariosBD.fechaBaja).append(",'").append(W83bClsConstantes.FORMATO_FECHA_EUSKARA);
			strSql.append("')").append(" AS ").append(W83bUsuariosBD.fechaBaja);

		}

		strSql.append(" FROM ").append(W83bUsuariosBD.usuariosVista);
		strSql.append(", ").append(W83bRolBD.rolesVista).append(" ROLES");
		strSql.append(", ").append(W83bSindicatosBD.sindicatosVista).append(" SIND");

		strSql.append(" WHERE ").append(W83bRolBD.rol).append("=");
		strSql.append(W83bUsuariosBD.rol);
		strSql.append(" and ").append(W83bSindicatosBD.codSindicato).append("=");
		strSql.append(W83bUsuariosBD.sindicato);
		/*
		 * strSql.append(" WHERE ").append(W83bSindicatosBD.codSindicato).append(
		 * " > 0 ");
		 */
		if (StringUtils.isNotEmpty(param.getDni())) {
			strSql.append(" AND ").append(W83bUsuariosBD.dniUsuario).append(" = ? ");
			params.add(param.getDni().toUpperCase());
		}
		if (StringUtils.isNotEmpty(param.getNombre())) {
			strSql.append(" AND ").append(W83bUsuariosBD.nombre).append(" LIKE ? ");
			params.add("%" + param.getNombre().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getApellido1())) {
			strSql.append(" AND ").append(W83bUsuariosBD.apellido1).append(" LIKE ? ");
			params.add("%" + param.getApellido1().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getApellido2())) {
			strSql.append(" AND ").append(W83bUsuariosBD.apellido2).append(" LIKE ? ");
			params.add("%" + param.getApellido2().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getSindicato())) {
			int pos = param.getSindicato().indexOf("|");
			String codigo = param.getSindicato().substring(0, pos);
			strSql.append(" AND ").append(W83bUsuariosBD.sindicato).append(" = ? ");
			params.add(codigo);
		}

		/*
		 * if(StringUtils.isNotEmpty(param.getCodVerificacion())){
		 * strSql.append(
		 * " AND ").append(W83bSindicatosBD.codVerificacion).append(" = ? ");
		 * params.add(param.getCodVerificacion().toUpperCase()); }
		 * if(StringUtils.isNotEmpty(param.getCodMadrid())){
		 * strSql.append(" AND "
		 * ).append(W83bSindicatosBD.codMadrid).append(" = ? ");
		 * params.add(param.getCodMadrid().toUpperCase()); }
		 * /*if(StringUtils.isNotEmpty(param.getStes())){
		 * strSql.append(" AND ").append(W83bSindicatosBD.stes).append(" = ? ");
		 * params.add(param.getStes().toUpperCase()); }
		 */
		/*
		 * if(StringUtils.isNotEmpty(param.getBaja())){
		 * strSql.append(" AND ").append
		 * (W83bSindicatosBD.baja).append(" IS NOT NULL "); } else{
		 * strSql.append
		 * (" AND ").append(W83bSindicatosBD.baja).append(" IS NULL "); }
		 * */
		 if(StringUtils.isNotEmpty(param.getIdColumna())){
			 strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());
		 }
		 

		W83bClsTrazas.traza(null,"#########la query de buscarusuarios es ########"+ strSql.toString());
		List listaUsuarios = W83bDataBase.executeQuery(strSql.toString(),params, w83b.w83bBeans.W83bUsuariosBean.class, param.getUsuarioBean(), null);

		return listaUsuarios;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#editarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public w83b.w83bBeans.W83bUsuariosBean detalleUsuarios(w83b.w83bBeans.W83bUsuariosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bUsuariosBD.dniUsuario).append(", ");
		strSql.append(W83bUsuariosBD.territorio).append(", ");
		strSql.append(W83bUsuariosBD.nombre).append(", ");
		strSql.append(W83bUsuariosBD.apellido1).append(", ");
		strSql.append(W83bUsuariosBD.apellido2).append(", ");
		strSql.append(W83bUsuariosBD.email).append(", TO_CHAR (");
		strSql.append(W83bUsuariosBD.fechaAlta).append(",?) F_ALTA_001 ,TO_CHAR (");
		strSql.append(W83bUsuariosBD.fechaBaja).append(",?)F_BAJA_001, ");
		strSql.append(W83bUsuariosBD.telefono).append(", ");
		strSql.append(W83bUsuariosBD.sindicato).append(", ");
		strSql.append(W83bUsuariosBD.rol);

		strSql.append(" FROM ").append(W83bUsuariosBD.usuariosVista);

		strSql.append(" WHERE ");
		strSql.append(W83bUsuariosBD.dniUsuario).append(" = ? ");
		
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getDni());

		List listaUsuarios = W83bDataBase.executeQuery(strSql.toString(),params, w83b.w83bBeans.W83bUsuariosBean.class, param.getUsuarioBean(), null);
		W83bUsuariosBean usuario = (w83b.w83bBeans.W83bUsuariosBean) listaUsuarios.get(0);
		System.out.println("El apellido 1 " + usuario.getApellido1());//NOPMD
		System.out.println("El apellido 2 " + usuario.getApellido2());//NOPMD
		return (w83b.w83bBeans.W83bUsuariosBean) listaUsuarios.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#modificarUsuarios(w83b.w83bBeans.W83bUsuariosBean)
	 */
	public String modificarUsuarios(w83b.w83bBeans.W83bUsuariosBean param)
			throws Exception {
		//Calendar c = new GregorianCalendar();//NOPMD

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bUsuariosBD.usuariosVista);
		strSql.append(" SET ");
		strSql.append(W83bUsuariosBD.nombre);
		strSql.append(" = UPPER(?) ");
		params.add(param.getNombre());
		strSql.append(", ");
		strSql.append(W83bUsuariosBD.apellido1);
		strSql.append(" = UPPER(?) ");
		params.add(param.getApellido1());
		strSql.append(", ");
		strSql.append(W83bUsuariosBD.apellido2);
		strSql.append(" = UPPER(?) ");
		params.add(param.getApellido2());
		strSql.append(", ");
		strSql.append(W83bUsuariosBD.email);
		strSql.append(" = ? ");
		params.add(param.getEmail());
		strSql.append(", ");
		strSql.append(W83bUsuariosBD.telefono);
		strSql.append(" = ? ");
		params.add(param.getTelefono());
		strSql.append(", ");
		strSql.append(W83bUsuariosBD.fechaAlta);
		strSql.append(" =  TO_DATE(?, 'DD/mm/YYYY') ");
		params.add(param.getFechaAlta());
		strSql.append(", ");
		if(StringUtils.isNotEmpty(param.getFechaBaja())){
			strSql.append(W83bUsuariosBD.fechaBaja);
			
			strSql.append(" =  TO_DATE(?, 'DD/mm/YYYY') ");
			params.add(param.getFechaBaja());
			strSql.append(", ");
		}else
		{
			strSql.append(W83bUsuariosBD.fechaBaja);
			strSql.append(" = '', ");
			
		}
		strSql.append(W83bUsuariosBD.territorio);
		strSql.append(" = ? ");
		params.add(param.getTerritorio());
		strSql.append(", ");
		strSql.append(W83bUsuariosBD.sindicato);
		strSql.append(" = ? ");
		params.add(param.getSindicato());
		strSql.append(", ");
		strSql.append(W83bUsuariosBD.rol);
		strSql.append(" = ? ");
		params.add(param.getRol());
		
		
		strSql.append(" WHERE ").append(W83bUsuariosBD.dniUsuario).append(" = ? ");
		params.add(param.getDni());
		
		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarUsuarios(w83b.w83bBeans.W83bUsuariosBean)
	 */
	public String borrarUsuarios(w83b.w83bBeans.W83bUsuariosBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bUsuariosBD.usuariosVista);
		strSql.append(" SET ");
		strSql.append(W83bUsuariosBD.fechaBaja);
		strSql.append(" =  TO_DATE(?, 'DD/mm/YYYY') ");
		params.add(param.getFechaBaja());
		strSql.append(" WHERE ").append(W83bUsuariosBD.dniUsuario).append(" = ? ");
		params.add(param.getDni());
		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());
		

		return "0";
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#anyadirUsuario(w83b.w83bBeans.W83bUsuariosBean)
	 */
	public String anyadirUsuario(w83b.w83bBeans.W83bUsuariosBean param)throws Exception {
		//Calendar c = new GregorianCalendar();//NOPMD

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bUsuariosBD.usuariosVista).append("(");
		strSql.append(W83bUsuariosBD.dniUsuario).append(",");
		strSql.append(W83bUsuariosBD.territorio).append(",");
		strSql.append(W83bUsuariosBD.nombre).append(",");
		strSql.append(W83bUsuariosBD.apellido1).append(",");
		strSql.append(W83bUsuariosBD.apellido2).append(",");
		strSql.append(W83bUsuariosBD.email).append(",");
		strSql.append(W83bUsuariosBD.fechaAlta).append(",");
		if(StringUtils.isNotEmpty(param.getFechaBaja())){
			strSql.append(W83bUsuariosBD.fechaBaja).append(",");
		}
		strSql.append(W83bUsuariosBD.telefono).append(",");
		strSql.append(W83bUsuariosBD.sindicato).append(",");
		strSql.append(W83bUsuariosBD.rol).append(") VALUES(");
		strSql.append("UPPER(?),?,UPPER(?),UPPER(?),UPPER(?),?,TO_DATE(?, 'DD/mm/YYYY'),");
		if(StringUtils.isNotEmpty(param.getFechaBaja())){
			strSql.append("TO_DATE(?, 'DD/mm/YYYY'),");
		}
		strSql.append("?,?,?) ");
		params.add(param.getDni());
		params.add(param.getTerritorio());
		params.add(param.getNombre());
		params.add(param.getApellido1());
		params.add(param.getApellido2());
		params.add(param.getEmail());
		params.add(param.getFechaAlta());
		if(StringUtils.isNotEmpty(param.getFechaBaja())){
			params.add(param.getFechaBaja());
		}
		params.add(param.getTelefono());
		params.add(param.getSindicato());
		params.add(param.getRol());
		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public java.util.List buscarCentroTrabajo(w83b.w83bBeans.W83bCentroTrabajoBean param) throws Exception {
		List listaCentroTrabajo = new ArrayList();
		try {
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();

			strSql.append("SELECT ");
			strSql.append(W83bCentroTrabajoVistaBD.codcentro).append(", ");
			strSql.append(" UPPER(").append(W83bCentroTrabajoVistaBD.cifnif).append(") AS ").append(W83bCentroTrabajoVistaBD.cifnif).append(",");
			strSql.append(W83bCentroTrabajoVistaBD.tipcifnif).append(", ");
			strSql.append(W83bCentroTrabajoVistaBD.nCentro).append(", ");
			strSql.append(" UPPER(").append(W83bCentroTrabajoVistaBD.razonsocial).append(") AS ").append(W83bCentroTrabajoVistaBD.razonsocial).append(",");
			strSql.append(" UPPER(").append(W83bCentroTrabajoVistaBD.domicilio).append(") AS ").append(W83bCentroTrabajoVistaBD.domicilio).append(",");
			strSql.append(W83bCentroTrabajoVistaBD.codTerritorio).append(", ");
			strSql.append(W83bCentroTrabajoVistaBD.codMunicipio).append(", ");
			strSql.append(" UPPER(").append(W83bCentroTrabajoVistaBD.municipio).append(") AS ").append(W83bCentroTrabajoVistaBD.municipio).append(",");
			strSql.append(" UPPER(").append(W83bCentroTrabajoVistaBD.territorio).append(") AS ").append(W83bCentroTrabajoVistaBD.territorio).append(",");
			strSql.append(" UPPER(").append(W83bCentroTrabajoVistaBD.territorio_eusk).append(") AS ").append(W83bCentroTrabajoVistaBD.territorio_eusk).append(",");
			strSql.append(W83bCentroTrabajoVistaBD.codpostal).append(", ");
			strSql.append(W83bCentroTrabajoVistaBD.cnae).append(", ");
			strSql.append(W83bCentroTrabajoVistaBD.bajacentro).append(", ");
			strSql.append(W83bCentroTrabajoVistaBD.telefono).append(", ");
			strSql.append(W83bCentroTrabajoVistaBD.fax).append(", ");
			strSql.append(W83bCentroTrabajoVistaBD.email);

			strSql.append(" FROM ").append(W83bCentroTrabajoVistaBD.nombreVista);

			boolean where = false;

			if (StringUtils.isNotEmpty(param.getCodCentroTrabajo())) {
				strSql.append(" WHERE ");
				where = true;
				strSql.append(" ").append(W83bCentroTrabajoVistaBD.codcentro).append(" = ?");
				params.add(new Integer(param.getCodCentroTrabajo()));
			}
			if (StringUtils.isNotEmpty(param.getCifnif())) {
				if (!where) {
					strSql.append(" WHERE ");
					where = true;
				} else {
					strSql.append(" AND ");
				}
				strSql.append(" ").append(W83bCentroTrabajoVistaBD.cifnif).append(" = ?");
				params.add(param.getCifnif().toUpperCase());
			}
			if (StringUtils.isNotEmpty(param.getNumCentro())) {
				if (!where) {
					strSql.append(" WHERE ");
					where = true;
				} else {
					strSql.append(" AND ");
				}
				strSql.append(" ").append(W83bCentroTrabajoVistaBD.nCentro).append(" = ?");
				params.add(param.getNumCentro());
			}
			if (StringUtils.isNotEmpty(param.getRazonSocial())) {
				if (!where) {
					strSql.append(" WHERE ");
					where = true;
				} else {
					strSql.append(" AND ");
				}
				strSql.append(" (UPPER(").append(
						W83bCentroTrabajoVistaBD.razonsocial)
						.append(") like ?");
				params.add(new StringBuffer(W83bClsConstantes.CUARENTA).append("%").append(param.getRazonSocial().toUpperCase()).append("%").toString());
				strSql.append(" OR ");
				strSql.append(" UPPER(").append(W83bCentroTrabajoVistaBD.razonsocialscaracteres).append(") like ?)");
				params.add(new StringBuffer(W83bClsConstantes.CUARENTA).append("%").append(param.getRazonSocial().toUpperCase()).append("%").toString());
			}

			if (!param.getIdColumna().equalsIgnoreCase(""))
				strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());

			listaCentroTrabajo = W83bDataBase.executeQuery(strSql.toString(),params, W83bCentroTrabajoBean.class,param.getUsuarioBean(), null);
		} catch (Exception e) {
			W83bClsTrazas.trazaError(null, "Errorbuscarcentrotrabajo", null);
			throw e;
		}

		return listaCentroTrabajo;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public int contarCentroTrabajo(w83b.w83bBeans.W83bCentroTrabajoBean param)
			throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT count(");
		strSql.append(W83bCentroTrabajoVistaBD.codcentro);
		strSql.append(")");

		strSql.append(" FROM ").append(W83bCentroTrabajoVistaBD.nombreVista);

		boolean where = false;

		if (StringUtils.isNotEmpty(param.getCodCentroTrabajo())) {
			strSql.append(" WHERE ");
			where = true;
			strSql.append(" ").append(W83bCentroTrabajoVistaBD.codcentro).append(" = ?");
			params.add(new Integer(param.getCodCentroTrabajo()));
		}
		if (StringUtils.isNotEmpty(param.getCifnif())) {
			if (!where) {
				strSql.append(" WHERE ");
				where = true;
			} else {
				strSql.append(" AND ");
			}
			strSql.append(" ").append(W83bCentroTrabajoVistaBD.cifnif).append(" = ?");
			params.add(param.getCifnif().toUpperCase());
		}
		if (StringUtils.isNotEmpty(param.getRazonSocial())) {
			if (!where) {
				strSql.append(" WHERE ");
				where = true;
			} else {
				strSql.append(" AND ");
			}
			strSql.append(" UPPER(").append(W83bCentroTrabajoVistaBD.razonsocial).append(") like ?");
			params.add(new StringBuffer(W83bClsConstantes.CUARENTA).append("%").append(param.getRazonSocial().toUpperCase()).append("%").toString());
		}
		strSql.append(" AND ").append(W83bCentroTrabajoVistaBD.bajacentro).append(" IS NULL ");

		List listaCentroTrabajo = W83bDataBase.executeSimpleQuery(strSql.toString(), params, param.getUsuarioBean());

		return Integer.parseInt(listaCentroTrabajo.get(0).toString());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#existeCodCentroTrabajo(java.lang.String)
	 */
	public boolean existeCodCentroTrabajo(String codCentroTrabajo)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bCentroTrabajoVistaBD.codcentro);

		strSql.append(" FROM ").append(W83bCentroTrabajoVistaBD.nombreVista);

		strSql.append(" WHERE ").append(W83bCentroTrabajoVistaBD.codcentro).append(" = ? ");
		params.add(new Integer(codCentroTrabajo));

		List listaCentroTrabajo = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaCentroTrabajo.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#existeCentroTrabajo(java.lang.String,java.lang.String)
	 */
	public boolean existeCentroTrabajo(String cifNifCentroTrabajo,String codCentro) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bCentroTrabajoVistaBD.codcentro);

		strSql.append(" FROM ").append(W83bCentroTrabajoVistaBD.nombreVista);

		strSql.append(" WHERE ").append(W83bCentroTrabajoVistaBD.cifnif).append(" = ? ");
		params.add(cifNifCentroTrabajo);
		strSql.append(" AND ").append(W83bCentroTrabajoVistaBD.nCentro).append(" = ? ");
		params.add(new Integer(codCentro));

		List listaCentroTrabajo = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaCentroTrabajo.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#devolverNumCentroCodCentro(w83b.w83bBeans.W83bCentroTrabajoBean)
	 */
	public List devolverNumCentroCodCentro(
			w83b.w83bBeans.W83bCentroTrabajoBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bCentroTrabajoBD.codigoCentro).append(", ");
		strSql.append(W83bCentroTrabajoBD.ncentroTrab);
		strSql.append(" FROM ").append(W83bCentroTrabajoBD.tablaCTDesa);

		strSql.append(" WHERE ").append(W83bCentroTrabajoBD.codNifCif).append(" = ? ");
		params.add(param.getCifnif().toUpperCase());
		strSql.append(" AND ").append(W83bCentroTrabajoBD.codMunicipioCentro).append(" = ? ");
		params.add(new Integer(param.getIdMunicipio()));
		strSql.append(" AND ").append(W83bCentroTrabajoBD.codProvinciaCentro).append(" = ? ");
		params.add(new Integer(param.getIdProvincia()));
		strSql.append(" AND ").append(W83bCentroTrabajoBD.razonSocialSCaractControl).append(" = ? ");
		params.add(W83bUtilidades.quitarCaracteresEspecialesEspacios(param.getNombre()).toUpperCase());
		// params.add((param.getNombre()).toUpperCase().trim());
		strSql.append(" AND ").append(W83bCentroTrabajoBD.codCNAE).append(" = ? ");
		params.add(new Integer(param.getIdCnae()));

		strSql.append(" AND ").append(W83bCentroTrabajoBD.codigoCentro).append(" = (");
		strSql.append("SELECT max(");
		strSql.append(W83bCentroTrabajoBD.codigoCentro);

		strSql.append(") FROM ").append(W83bCentroTrabajoBD.tablaCTDesa);

		strSql.append(" WHERE ").append(W83bCentroTrabajoBD.codNifCif).append(" = ? ");
		params.add(param.getCifnif().toUpperCase());
		strSql.append(" AND ").append(W83bCentroTrabajoBD.codMunicipioCentro).append(" = ? ");
		params.add(new Integer(param.getIdMunicipio()));
		strSql.append(" AND ").append(W83bCentroTrabajoBD.codProvinciaCentro).append(" = ? ");
		params.add(new Integer(param.getIdProvincia()));
		strSql.append(" AND ").append(W83bCentroTrabajoBD.razonSocialSCaractControl).append(" = ? ");
		params.add(W83bUtilidades.quitarCaracteresEspecialesEspacios(param.getNombre()).toUpperCase());
		// params.add((param.getNombre()).toUpperCase().trim());
		strSql.append(" AND ").append(W83bCentroTrabajoBD.codCNAE).append(" = ?) ");
		params.add(new Integer(param.getIdCnae()));

		List listaCentroTrabajo = W83bDataBase.executeQuery(strSql.toString(),params, null);

		return listaCentroTrabajo;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#anyadirCentroTrabajo(w83b.w83bBeans.W83bCentroTrabajoBean)
	 */
	public java.lang.String anyadirCentroTrabajo(w83b.w83bBeans.W83bCentroTrabajoBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bCentroTrabajoBD.tablaCTDesa);
		strSql.append("(");
		strSql.append(W83bCentroTrabajoBD.tipCifNif);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codNifCif);
		strSql.append(", ");

		strSql.append(W83bCentroTrabajoBD.razonSocial);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.razonSocialSCaractControl);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.domicilioCentro);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codPostalCentro);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codProvinciaCentro);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codMunicipioCentro);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.localidadCentro);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.tfno);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.fax);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.nomComercial);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.domicilioFiscalCentro);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codProvDomicilioFiscal);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codMunDomicilioFiscal);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codPostalDomicilioFiscal);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codCNAE);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codDivisionNCAE);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codGrupoNCAE);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codClaseNCAE);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codSector);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codigoRegJuridico);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.nTrabajadores);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codMotivoBaja);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.fecBaja);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.fecActualizacion);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.observaciones);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.userActualizacion);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.razonSocial7);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.razonSocialSCaractControl7);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codCNAE7);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.codSector7);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.userActualizacion7);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.usualta);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoBD.indiceTipoCentro);
		strSql.append(")");

		strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,");
		if (StringUtils.isNotEmpty(param.getFechaBaja())) {
			strSql.append("TO_DATE(?,?)");
		} else {
			strSql.append("?");
		}
		if (StringUtils.isNotEmpty(param.getFechaUltimaActualizacion())) {
			strSql.append(",TO_DATE(?,?)");
		} else {
			strSql.append(",?");
		}

		strSql.append(",?,?,?,?,?,?,?,?,?)");

		params.add(param.getTipoNifCifCtoTrabajo());
		params.add(param.getCifnif().toUpperCase());

		params.add(param.getNombre().toUpperCase());
		// params.add((param.getNombre()).toUpperCase().trim());
		params.add(W83bUtilidades.quitarCaracteresEspecialesEspacios(param.getNombre()).toUpperCase());
		if (StringUtils.isNotEmpty(param.getDomicilio())) {
			params.add(param.getDomicilio().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(param.getCodPostal());
		params.add(new Integer(param.getIdProvincia()));
		params.add(new Integer(param.getIdMunicipio()));
		if (StringUtils.isNotEmpty(param.getLocalidad())) {
			params.add(param.getLocalidad().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getTelefono())) {
			params.add(param.getTelefono());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getFax())) {
			params.add(param.getFax());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getNombreComercial())) {
			params.add(param.getNombreComercial().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDomicilioFiscal())) {
			params.add(param.getDomicilioFiscal().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(new Integer(param.getProvinciaFiscal()));
		params.add(new Integer(param.getMunicipioFiscal()));
		params.add(param.getCodPostalFiscal());

		params.add(param.getIdCnae());
		params.add(param.getIdCnae().substring(0, 2));
		params.add(param.getIdCnae().substring(2, 3));
		params.add(param.getIdCnae().substring(3, 4));
		params.add(param.getIdSector().toUpperCase());
		params.add(param.getIdRegJur().toUpperCase());
		if (StringUtils.isNotEmpty(param.getNumTrabajadores())) {
			params.add(new Integer(param.getNumTrabajadores()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if (StringUtils.isNotEmpty(param.getIdMotivoBaja())) {
			params.add(param.getIdMotivoBaja());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getFechaBaja())) {
			params.add(param.getFechaBaja());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		} else {
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if (StringUtils.isNotEmpty(param.getFechaUltimaActualizacion())) {
			params.add(param.getFechaUltimaActualizacion());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		} else {
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if (StringUtils.isNotEmpty(param.getObservaciones())) {
			params.add(param.getObservaciones());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(param.getUsuarioBean().getIdUsuario());
		params.add(param.getNombre().toUpperCase());
		params.add(W83bUtilidades.quitarCaracteresEspecialesEspacios(param.getNombre()).toUpperCase());
		// params.add((param.getNombre()).toUpperCase().trim());
		params.add(param.getIdCnae());
		params.add(param.getIdSector().toUpperCase());
		params.add(param.getUsuarioBean().getIdUsuario());
		params.add(param.getUsuarioBean().getIdUsuario());
		params.add(W83bClsConstantes.CONSTANTE_INDTIPCENTRO);

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/**
	 * Anyadir centro trabajo j73b01t00.
	 * 
	 * @param param the param
	 * @return the java.lang. string
	 * @throws Exception the exception
	 */
	public java.lang.String anyadirCentroTrabajoJ73b01t00(w83b.w83bBeans.W83bCentroTrabajoBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bCentroTrabajoBD.J7301S00);
		strSql.append("(");
		strSql.append(W83bCentroTrabajoBD.codNifCif);

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarComarca(java.lang.String,java.lang.String)
	 */
	public java.util.List buscarComarca(String codProvincia, String codMunicipio)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bComarcaVistaBD.IDCOMARCA);
		strSql.append(", ");
		strSql.append(W83bComarcaVistaBD.DESCCOMARCA);
		strSql.append(" FROM ");
		strSql.append(W83bComarcaVistaBD.comarcaView);
		strSql.append(" WHERE ");
		strSql.append(W83bComarcaVistaBD.IDPROVINCIA);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bComarcaVistaBD.IDMUNICIPIO);
		strSql.append(" = ? ");
		params.add(codProvincia);
		params.add(codMunicipio);

		List listaDatosParametros = W83bDataBase.executeQuery(strSql.toString(), params, null);

		return listaDatosParametros;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#cargarCnae(java.util.HashMap)
	 */
	public java.util.List cargarCnae(HashMap mapaResultado) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bCnaeVistaBD.IDCNAE);
		strSql.append(" || '_' ||");
		strSql.append(W83bCnaeVistaBD.IDSECTOR);
		strSql.append(" AS codigo, ");
		strSql.append(W83bCnaeVistaBD.DESCCNAE);
		strSql.append(" as descripcion ");
		strSql.append(" FROM ");
		strSql.append(W83bCnaeVistaBD.cnaeView);
		strSql.append(" WHERE UPPER(");
		strSql.append(W83bCnaeVistaBD.DESCCNAE);
		strSql.append(") LIKE UPPER(?)");
		params.add(new StringBuffer(W83bClsConstantes.CUARENTA).append(mapaResultado.get("q")).append("%").toString());
		if (StringUtils.isNotEmpty((String) mapaResultado.get("limit"))) {
			strSql.append(" and ROWNUM <= ? ");
			params.add((String) mapaResultado.get("limit"));
		}

		List listaDatosParametros = W83bDataBase.executeQuery(strSql.toString(), params, null);

		return listaDatosParametros;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#detalleCentroTrabajo(java.lang.String, java.lang.String, java.lang.String)
	 */
	public java.util.List detalleCentroTrabajo(String cifnif,
			String nCentroTrabajo, String idioma) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.cifNif);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.cifNif);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.tipoCif);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.nCentroTrabajo);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codCentro);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.razonSocial);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.domicilio);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codPostal);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codTerritorio);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codMunicipio);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.localidad);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codComarca);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.comarca);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.telefono);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.fax);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.nombreComercial);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.domicilioFiscal);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codTerritorioFiscal);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codMunicipioFiscal);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codPostalFiscal);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codCnae);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.cnae);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codSector);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codRegJurid);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.numTrabajadores);
		strSql.append(", ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codBaja);
		strSql.append(", TO_CHAR(");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.fecBaja);
		strSql.append(",?) AS ").append(W83bCentroTrabajoCompletoVistaBD.fecBaja);
		strSql.append(", TO_CHAR(");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bCentroTrabajoCompletoVistaBD.fecUltimaActualizacion);
		strSql.append(",?) AS ").append(W83bCentroTrabajoCompletoVistaBD.fecUltimaActualizacion);
		strSql.append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bCentroTrabajoCompletoVistaBD.observaciones);
		strSql.append(" FROM ").append(W83bCentroTrabajoCompletoVistaBD.nombreVista);
		strSql.append(" WHERE ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.cifNif).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.nCentroTrabajo).append(" = ?");
		params.add(cifnif);
		params.add(nCentroTrabajo);

		List listaDatosParametros = W83bDataBase.executeQuery(strSql.toString(), params, W83bCentroTrabajoCompletoBean.class,null, null);

		return listaDatosParametros;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#cargarCnaeCodigo(java.lang.String)
	 */
	public java.util.List cargarCnaeCodigo(String codigo) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bCnaeVistaBD.IDCNAE);
		strSql.append(" || '_' ||");
		strSql.append(W83bCnaeVistaBD.IDSECTOR);
		strSql.append(" AS codigo, ");
		strSql.append(W83bCnaeVistaBD.DESCCNAE);
		strSql.append(" as descripcion ");
		strSql.append(" FROM ");
		strSql.append(W83bCnaeVistaBD.cnaeView);
		strSql.append(" WHERE ");
		strSql.append(W83bCnaeVistaBD.IDCNAE);
		strSql.append(" = ?");
		params.add(codigo);

		List listaDatosParametros = W83bDataBase.executeQuery(strSql.toString(), params, null);

		return listaDatosParametros;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#maxCodCentroTrabajo()
	 */
	public String maxCodCentroTrabajo() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT MAX(");
		strSql.append(W83bCentroTrabajoVistaBD.codcentro);

		strSql.append(") FROM ").append(W83bCentroTrabajoVistaBD.nombreVista);

		List listaAgrupaciones = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		return listaAgrupaciones.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarMotivosBajaDelegado(w83b.w83bBeans.W83bMotivosBajaDelegadoBean)
	 */
	public java.util.List buscarMotivosBajaDelegado(w83b.w83bBeans.W83bMotivosBajaDelegadoBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bMotivosBajaDelegadoBD.codMotivo).append(", ");
		strSql.append(W83bMotivosBajaDelegadoBD.descMotivoCast).append(", ");
		strSql.append(W83bMotivosBajaDelegadoBD.descMotivoEusk);

		strSql.append(" FROM ").append(W83bMotivosBajaDelegadoBD.motivosBajaVista);

		strSql.append(" WHERE ").append(W83bMotivosBajaDelegadoBD.codMotivo).append(" > 0 ");
		if (StringUtils.isNotEmpty(param.getCodMotivoBajaDelegado())) {
			strSql.append(" AND ").append(W83bMotivosBajaDelegadoBD.codMotivo).append(" = ? ");
			params.add(new Integer(param.getCodMotivoBajaDelegado()));
		}
		if (StringUtils.isNotEmpty(param.getDescMotivoBajaDelegadoCast())) {
			strSql.append(" AND ").append(W83bMotivosBajaDelegadoBD.descMotivoCast).append(" LIKE ? ");
			params.add("%"+ param.getDescMotivoBajaDelegadoCast().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getDescMotivoBajaDelegadoEusk())) {
			strSql.append(" AND ").append(W83bMotivosBajaDelegadoBD.descMotivoEusk).append(" LIKE ? ");
			params.add("%"+ param.getDescMotivoBajaDelegadoEusk().toUpperCase() + "%");
		}

		if (StringUtils.isNotEmpty(param.getBaja())) {
			strSql.append(" AND ").append(W83bMotivosBajaDelegadoBD.baja).append(" IS NOT NULL ");
		} else {
			strSql.append(" AND ").append(W83bMotivosBajaDelegadoBD.baja).append(" IS NULL ");
		}
		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());

		List listaMotivos = W83bDataBase.executeQuery(strSql.toString(),params, W83bMotivosBajaDelegadoBean.class, param.getUsuarioBean(), null);

		return listaMotivos;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#maxCodMotivoBajaDelegado()
	 */
	public String maxCodMotivoBajaDelegado() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT NVL(MAX(");
		strSql.append(W83bMotivosBajaDelegadoBD.codMotivo);

		strSql.append("),0) FROM ").append(W83bMotivosBajaDelegadoBD.motivosBajaVista);

		List listaMotivos = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		return listaMotivos.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#contarMotivosBajaDelegado()
	 */
	public String contarMotivosBajaDelegado() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT COUNT(");
		strSql.append(W83bMotivosBajaDelegadoBD.codMotivo);

		strSql.append(") FROM ").append(W83bMotivosBajaDelegadoBD.motivosBajaVista);

		List listaMotivos = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		return listaMotivos.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#existeMotivoBajaDelegado(java.lang.String)
	 */
	public boolean existeMotivoBajaDelegado(String codMotivo) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bMotivosBajaDelegadoBD.codMotivo);

		strSql.append(" FROM ").append(W83bMotivosBajaDelegadoBD.motivosBajaVista);

		strSql.append(" WHERE ").append(W83bMotivosBajaDelegadoBD.codMotivo).append(" = ? ");
		params.add(new Integer(codMotivo));

		List listaMotivos = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		if (listaMotivos.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#anyadirMotivoBajaDelegado(w83b.w83bBeans.W83bMotivosBajaDelegadoBean)
	 */
	public String anyadirMotivoBajaDelegado(
			w83b.w83bBeans.W83bMotivosBajaDelegadoBean param) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bMotivosBajaDelegadoBD.motivosBajaVista);
		strSql.append("(");
		strSql.append(W83bMotivosBajaDelegadoBD.codMotivo);
		strSql.append(",");
		strSql.append(W83bMotivosBajaDelegadoBD.descMotivoCast);
		strSql.append(",");
		strSql.append(W83bMotivosBajaDelegadoBD.descMotivoEusk);
		strSql.append(") VALUES (?,UPPER(?),UPPER(?))");

		params.add(new Integer(param.getCodMotivoBajaDelegado()));

		if (StringUtils.isNotEmpty(param.getDescMotivoBajaDelegadoCast())) {
			params.add(param.getDescMotivoBajaDelegadoCast());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescMotivoBajaDelegadoEusk())) {
			params.add(param.getDescMotivoBajaDelegadoEusk());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#modificarMotivoBajaDelegado(w83b.w83bBeans.W83bMotivosBajaDelegadoBean)
	 */
	public String modificarMotivoBajaDelegado(
			w83b.w83bBeans.W83bMotivosBajaDelegadoBean param) throws Exception {
		Calendar c = new GregorianCalendar();

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bMotivosBajaDelegadoBD.motivosBajaVista);
		strSql.append(" SET ");
		strSql.append(W83bMotivosBajaDelegadoBD.descMotivoCast);
		strSql.append(" = UPPER(?) ");
		strSql.append(", ");
		strSql.append(W83bMotivosBajaDelegadoBD.descMotivoEusk);
		strSql.append(" = UPPER(?) ");
		strSql.append(", ");
		strSql.append(W83bMotivosBajaDelegadoBD.baja);
		strSql.append(" = ? ");

		strSql.append(" WHERE ").append(W83bMotivosBajaDelegadoBD.codMotivo).append(" = ? ");

		if (StringUtils.isNotEmpty(param.getDescMotivoBajaDelegadoCast())) {
			params.add(param.getDescMotivoBajaDelegadoCast());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescMotivoBajaDelegadoEusk())) {
			params.add(param.getDescMotivoBajaDelegadoEusk());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getBaja())) {
			params.add(Integer.toString(c.get(Calendar.DATE)) + "/"
					+ Integer.toString(c.get(Calendar.MONTH)) + "/"
					+ Integer.toString(c.get(Calendar.YEAR)));
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(new Integer(param.getCodMotivoBajaDelegado()));

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#detalleMotivoBajaDelegado(w83b.w83bBeans.W83bMotivosBajaDelegadoBean)
	 */
	public w83b.w83bBeans.W83bMotivosBajaDelegadoBean detalleMotivoBajaDelegado(w83b.w83bBeans.W83bMotivosBajaDelegadoBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bMotivosBajaDelegadoBD.codMotivo).append(", ");
		strSql.append(W83bMotivosBajaDelegadoBD.descMotivoCast);
		strSql.append(", ");
		strSql.append(W83bMotivosBajaDelegadoBD.descMotivoEusk);
		strSql.append(", ");
		strSql.append(W83bMotivosBajaDelegadoBD.baja);

		strSql.append(" FROM ").append(W83bMotivosBajaDelegadoBD.motivosBajaVista);

		strSql.append(" WHERE ");
		strSql.append(W83bMotivosBajaDelegadoBD.codMotivo).append(" = ? ");
		params.add(new Integer(param.getCodMotivoBajaDelegado()));

		List listaMotivos = W83bDataBase.executeQuery(strSql.toString(),params, W83bMotivosBajaDelegadoBean.class, param.getUsuarioBean(), null);

		for (int i = 0; i < listaMotivos.size(); i++) {
			W83bMotivosBajaDelegadoBean mbd = (W83bMotivosBajaDelegadoBean) listaMotivos.get(i);
			if (mbd.getBaja() != null && !"".equals(mbd.getBaja())) {
				mbd.setBaja(W83bClsConstantes.BAJA);
			}
		}

		return (W83bMotivosBajaDelegadoBean) listaMotivos.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#buscarEmpresas(w83b.w83bBeans.W83bEmpresasBean)
	 */
	public java.util.List buscarEmpresas(w83b.w83bBeans.W83bEmpresasBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bTipoEmpresaBD.codigo).append(", ");
		strSql.append(W83bTipoEmpresaBD.descripcion).append(", ");
		strSql.append(W83bTipoEmpresaBD.descripcion_eusk).append(", ");
		strSql.append(W83bTipoEmpresaBD.baja);

		strSql.append(" FROM ").append(W83bTipoEmpresaBD.tipoEmpresaTable);

		strSql.append(" WHERE ").append(W83bTipoEmpresaBD.codigo).append(" > 0 ");
		if (StringUtils.isNotEmpty(param.getCodEmpresas())) {
			strSql.append(" AND ").append(W83bTipoEmpresaBD.codigo).append(" = ? ");
			params.add(new Integer(param.getCodEmpresas()));
		}
		if (StringUtils.isNotEmpty(param.getDescEmpresas())) {
			strSql.append(" AND UPPER(").append(W83bTipoEmpresaBD.descripcion).append(") LIKE ? ");
			params.add("%" + param.getDescEmpresas().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getDescEmpresasEusk())) {
			strSql.append(" AND UPPER(").append(W83bTipoEmpresaBD.descripcion_eusk).append(") LIKE ? ");
			params.add("%" + param.getDescEmpresasEusk().toUpperCase() + "%");
		}
		if (StringUtils.isEmpty(param.getBaja())
				|| param.getBaja().equals(W83bClsConstantes.ALTA)) {
			strSql.append(" AND ").append(W83bTipoEmpresaBD.baja).append(" IS NULL");
		} else {
			strSql.append(" AND ").append(W83bTipoEmpresaBD.baja).append(" IS NOT NULL");
		}

		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());

		List listaEmpresas = W83bDataBase.executeQuery(strSql.toString(),params, W83bEmpresasBean.class, param.getUsuarioBean(), null);

		return listaEmpresas;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#editarEmpresas(w83b.w83bBeans.W83bEmpresasBean)
	 */
	public w83b.w83bBeans.W83bEmpresasBean detalleEmpresas(w83b.w83bBeans.W83bEmpresasBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bTipoEmpresaBD.codigo).append(", ");
		strSql.append(W83bTipoEmpresaBD.descripcion).append(", ");
		strSql.append(W83bTipoEmpresaBD.descripcion_eusk).append(", ");
		strSql.append(W83bTipoEmpresaBD.baja);

		strSql.append(" FROM ").append(W83bTipoEmpresaBD.tipoEmpresaTable);

		strSql.append(" WHERE ");
		strSql.append(W83bTipoEmpresaBD.codigo).append(" = ? ");
		params.add(new Integer(param.getCodEmpresas()));

		List listaEmpresas = W83bDataBase.executeQuery(strSql.toString(),params, W83bEmpresasBean.class, param.getUsuarioBean(), null);

		return (W83bEmpresasBean) listaEmpresas.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#anyadirEmpresas(w83b.w83bBeans.W83bEmpresasBean)
	 */
	public java.lang.String anyadirEmpresas(
			w83b.w83bBeans.W83bEmpresasBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bTipoEmpresaBD.tipoEmpresaTable);
		strSql.append("(");
		strSql.append(W83bTipoEmpresaBD.codigo);
		strSql.append(",");
		strSql.append(W83bTipoEmpresaBD.descripcion);
		strSql.append(",");
		strSql.append(W83bTipoEmpresaBD.descripcion_eusk);
		strSql.append(") VALUES (?,UPPER(?),UPPER(?))");

		params.add(new Integer(param.getCodEmpresas()));

		if (StringUtils.isNotEmpty(param.getDescEmpresas())) {
			params.add(param.getDescEmpresas());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescEmpresasEusk())) {
			params.add(param.getDescEmpresasEusk());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#anyadirEmpresas(w83b.w83bBeans.W83bEmpresasBean)
	 */
	public java.lang.String modificarEmpresas(w83b.w83bBeans.W83bEmpresasBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bTipoEmpresaBD.tipoEmpresaTable);
		strSql.append(" SET ");
		strSql.append(W83bTipoEmpresaBD.descripcion);
		strSql.append(" = UPPER(?) ");
		strSql.append(", ");
		strSql.append(W83bTipoEmpresaBD.descripcion_eusk);
		strSql.append(" = UPPER(?) ");
		strSql.append(", ");
		strSql.append(W83bTipoEmpresaBD.baja);
		strSql.append(" = ? ");
		strSql.append(" WHERE ").append(W83bTipoEmpresaBD.codigo).append(" = ? ");
		if (StringUtils.isNotEmpty(param.getDescEmpresas())) {
			params.add(param.getDescEmpresas());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescEmpresasEusk())) {
			params.add(param.getDescEmpresasEusk());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getBaja())&& W83bClsConstantes.BAJA.equals(param.getBaja())) {

			SimpleDateFormat formatter = new java.text.SimpleDateFormat("dd/MM/yyyy");
			Date diaActual = new java.util.Date();
			params.add(formatter.format(diaActual));
		} else {
			params.add(W83bClsConstantes.NULL_DATE);
		}

		params.add(new Integer(param.getCodEmpresas()));
		W83bClsTrazas.traza(param.getUsuarioBean(),"sql modificar empresa --> " + strSql.toString());
		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#maxCodEmpresa()
	 */
	public String maxCodEmpresa() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT NVL(MAX(");
		strSql.append(W83bTipoEmpresaBD.codigo);

		strSql.append("),0) FROM ").append(W83bTipoEmpresaBD.tipoEmpresaTable);

		List listaAgrupaciones = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		return listaAgrupaciones.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#contarEmpresas()
	 */
	public String contarEmpresas() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT COUNT(");
		strSql.append(W83bTipoEmpresaBD.codigo);

		strSql.append(") FROM ").append(W83bTipoEmpresaBD.tipoEmpresaTable);

		List listaEmpresas = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		return listaEmpresas.get(0).toString();
	}

	/**
	 * Existe empresa.
	 * 
	 * @param codEmpresa the cod empresa
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeEmpresa(String codEmpresa) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bTipoEmpresaBD.codigo);

		strSql.append(" FROM ").append(W83bTipoEmpresaBD.tipoEmpresaTable);

		strSql.append(" WHERE ").append(W83bTipoEmpresaBD.codigo).append(" = ? ");
		params.add(new Integer(codEmpresa));

		List listaAgrupaciones = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaAgrupaciones.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarMotivosBajaActa(w83b.w83bBeans.W83bMotivosBajaActaBean)
	 */
	public java.util.List buscarMotivosBajaActa(
			w83b.w83bBeans.W83bMotivosBajaActaBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bMotivosBajaActaBD.codMotivo).append(", ");

		strSql.append(W83bMotivosBajaActaBD.descMotivoCast).append(", ");

		strSql.append(W83bMotivosBajaActaBD.descMotivoEusk);

		strSql.append(" FROM ").append(W83bMotivosBajaActaBD.motivosBajaVista);

		strSql.append(" WHERE ").append(W83bMotivosBajaActaBD.codMotivo).append(" > 0 ");
		if (StringUtils.isNotEmpty(param.getCodMotivoBajaActa())) {
			strSql.append(" AND ").append(W83bMotivosBajaActaBD.codMotivo).append(" = ? ");
			params.add(new Integer(param.getCodMotivoBajaActa()));
		}
		if (StringUtils.isNotEmpty(param.getDescMotivoBajaActaCast())) {
			strSql.append(" AND ").append(W83bMotivosBajaActaBD.descMotivoCast).append(" LIKE ? ");
			params.add("%" + param.getDescMotivoBajaActaCast().toUpperCase()+ "%");
		}
		if (StringUtils.isNotEmpty(param.getDescMotivoBajaActaEusk())) {
			strSql.append(" AND ").append(W83bMotivosBajaActaBD.descMotivoEusk).append(" LIKE ? ");
			params.add("%" + param.getDescMotivoBajaActaEusk().toUpperCase()+ "%");
		}

		if (StringUtils.isNotEmpty(param.getBaja())) {
			strSql.append(" AND ").append(W83bMotivosBajaActaBD.baja).append(" IS NOT NULL ");
		} else {
			strSql.append(" AND ").append(W83bMotivosBajaActaBD.baja).append(" IS NULL ");
		}

		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());

		List listaMotivos = W83bDataBase.executeQuery(strSql.toString(),params, W83bMotivosBajaActaBean.class, param.getUsuarioBean(),null);

		return listaMotivos;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#maxCodMotivoBajaActa()
	 */
	public String maxCodMotivoBajaActa() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT NVL(MAX(");
		strSql.append(W83bMotivosBajaActaBD.codMotivo);

		strSql.append("),0) FROM ").append(W83bMotivosBajaActaBD.motivosBajaVista);

		List listaMotivos = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		return listaMotivos.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#contarMotivosBajaActa()
	 */
	public String contarMotivosBajaActa() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT COUNT(");
		strSql.append(W83bMotivosBajaActaBD.codMotivo);

		strSql.append(") FROM ").append(W83bMotivosBajaActaBD.motivosBajaVista);

		List listaMotivos = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		return listaMotivos.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#existeMotivoBajaActa(java.lang.String)
	 */
	public boolean existeMotivoBajaActa(String codMotivo) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bMotivosBajaActaBD.codMotivo);

		strSql.append(" FROM ").append(W83bMotivosBajaActaBD.motivosBajaVista);

		strSql.append(" WHERE ").append(W83bMotivosBajaActaBD.codMotivo)
				.append(" = ? ");
		params.add(new Integer(codMotivo));

		List listaMotivos = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		if (listaMotivos.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#anyadirMotivoBajaActa(w83b.w83bBeans.W83bMotivosBajaActaBean)
	 */
	public String anyadirMotivoBajaActa(
			w83b.w83bBeans.W83bMotivosBajaActaBean param) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bMotivosBajaActaBD.motivosBajaVista);
		strSql.append("(");
		strSql.append(W83bMotivosBajaActaBD.codMotivo);
		strSql.append(",");
		strSql.append(W83bMotivosBajaActaBD.descMotivoCast);
		strSql.append(",");
		strSql.append(W83bMotivosBajaActaBD.descMotivoEusk);
		strSql.append(") VALUES (?,UPPER(?),UPPER(?))");

		params.add(new Integer(param.getCodMotivoBajaActa()));

		if (StringUtils.isNotEmpty(param.getDescMotivoBajaActaCast())) {
			params.add(param.getDescMotivoBajaActaCast());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescMotivoBajaActaEusk())) {
			params.add(param.getDescMotivoBajaActaEusk());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#modificarMotivoBajaActa(w83b.w83bBeans.W83bMotivosBajaActaBean)
	 */
	public String modificarMotivoBajaActa(
			w83b.w83bBeans.W83bMotivosBajaActaBean param) throws Exception {
		Calendar c = new GregorianCalendar();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bMotivosBajaActaBD.motivosBajaVista);
		strSql.append(" SET ");
		strSql.append(W83bMotivosBajaActaBD.descMotivoCast);
		strSql.append(" = UPPER(?) ");
		strSql.append(", ");
		strSql.append(W83bMotivosBajaActaBD.descMotivoEusk);
		strSql.append(" = UPPER(?) ");
		strSql.append(", ");
		strSql.append(W83bMotivosBajaActaBD.baja);
		strSql.append(" = ? ");
		strSql.append(" WHERE ").append(W83bMotivosBajaActaBD.codMotivo).append(" = ? ");

		if (StringUtils.isNotEmpty(param.getDescMotivoBajaActaCast())) {
			params.add(param.getDescMotivoBajaActaCast());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescMotivoBajaActaEusk())) {
			params.add(param.getDescMotivoBajaActaEusk());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getBaja())) {
			params.add(Integer.toString(c.get(Calendar.DATE)) + "/"
					+ Integer.toString(c.get(Calendar.MONTH)) + "/"
					+ Integer.toString(c.get(Calendar.YEAR)));
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(new Integer(param.getCodMotivoBajaActa()));

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#detalleMotivoBajaActa(w83b.w83bBeans.W83bMotivosBajaActaBean)
	 */
	public w83b.w83bBeans.W83bMotivosBajaActaBean detalleMotivoBajaActa(w83b.w83bBeans.W83bMotivosBajaActaBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bMotivosBajaActaBD.codMotivo).append(", ");
		strSql.append(W83bMotivosBajaActaBD.descMotivoCast);
		strSql.append(", ");
		strSql.append(W83bMotivosBajaActaBD.descMotivoEusk);
		strSql.append(", ");
		strSql.append(W83bMotivosBajaActaBD.baja);

		strSql.append(" FROM ").append(W83bMotivosBajaActaBD.motivosBajaVista);

		strSql.append(" WHERE ");
		strSql.append(W83bMotivosBajaActaBD.codMotivo).append(" = ? ");
		params.add(new Integer(param.getCodMotivoBajaActa()));

		List listaMotivos = W83bDataBase.executeQuery(strSql.toString(),params, W83bMotivosBajaActaBean.class, param.getUsuarioBean(),null);

		for (int i = 0; i < listaMotivos.size(); i++) {
			W83bMotivosBajaActaBean mbd = (W83bMotivosBajaActaBean) listaMotivos.get(i);
			if (mbd.getBaja() != null && !"".equals(mbd.getBaja())) {
				mbd.setBaja(W83bClsConstantes.BAJA);
			}
		}

		return (W83bMotivosBajaActaBean) listaMotivos.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#buscarRespArea(w83b.w83bBeans.W83bRespAreaBean)
	 */
	public java.util.List buscarRespArea(w83b.w83bBeans.W83bRespAreaBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		// TODO hacer sqlquery!

		strSql.append("SELECT TRESP.");
		strSql.append(W83bRespAreaBD.codigoResponsable).append(", TRESP.");
		strSql.append(W83bRespAreaBD.territorio).append(", TRESP.");
		strSql.append(W83bRespAreaBD.nombreResponsable).append(", TRESP.");
		strSql.append(W83bRespAreaBD.perfilId).append(", TPERF.");
		strSql.append(W83bRespAreaBD.isPerfilCentrales).append(", TPERF.");
		strSql.append(W83bRespAreaBD.perfilDesc).append(", TPERF.");
		strSql.append(W83bRespAreaBD.perfilDescEus).append(", TRESP.");
		strSql.append(W83bRespAreaBD.baja);

		strSql.append(" FROM ").append(W83bRespAreaBD.respAreaTable).append(" TRESP");
		strSql.append(", ").append(W83bRespAreaBD.perfilTable).append(" TPERF");

		strSql.append(" WHERE TRESP.").append(W83bRespAreaBD.perfilId).append(" =  TPERF.").append(W83bRespAreaBD.codPerfil);

		if (StringUtils.isNotEmpty(param.getTerritorio())) {
			strSql.append(" AND TRESP.").append(W83bRespAreaBD.territorio).append(" = ? ");
			params.add(new Integer(param.getTerritorio()));

		}
		if (StringUtils.isNotEmpty(param.getCodigoResponsable())) {

			strSql.append(" AND TRESP.").append(W83bRespAreaBD.codigoResponsable).append(" = ? ");
			params.add(param.getCodigoResponsable());
		}
		if (StringUtils.isNotEmpty(param.getNombreResponsable())) {
			strSql.append(" AND UPPER(").append("TRESP.").append(W83bRespAreaBD.nombreResponsable).append(") LIKE ? ");
			params.add("%" + param.getNombreResponsable().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getPerfilId())) {
			strSql.append(" AND TRESP.").append(W83bRespAreaBD.perfilId).append(" = ? ");
			params.add(param.getPerfilId());
		}
		if (StringUtils.isNotEmpty(param.getBaja())) {
			strSql.append(" AND TRESP.").append(W83bRespAreaBD.baja).append(" is not null");
		} else {
			strSql.append(" AND TRESP.").append(W83bRespAreaBD.baja).append(" is null");
		}

		if ((W83bClsConstantes.CUATRO + "").equalsIgnoreCase(param.getIdColumna())) {
			strSql.append(" ORDER BY ").append(W83bRespAreaBD.perfilDesc).append(" ").append(param.getSort());
		} else if ((W83bClsConstantes.CINCO + "").equalsIgnoreCase(param.getIdColumna())) {
			strSql.append(" ORDER BY ").append(W83bRespAreaBD.perfilDescEus).append(" ").append(param.getSort());
		} else {
			strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());
		}

		String idLanguage = param.getIdioma();
		String servCentrales = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.respArea.servCentrales", idLanguage).toUpperCase();

		List listaRespArea = W83bDataBase.executeQuery(strSql.toString(),params, W83bRespAreaBean.class, param.getUsuarioBean(),servCentrales);

		return listaRespArea;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#detalleRespArea(w83b.w83bBeans.W83bRespAreaBean)
	 */
	public w83b.w83bBeans.W83bRespAreaBean detalleRespArea(w83b.w83bBeans.W83bRespAreaBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT TRESP.");
		strSql.append(W83bRespAreaBD.codigoResponsable).append(", TRESP.");
		strSql.append(W83bRespAreaBD.territorio).append(", TRESP.");
		strSql.append(W83bRespAreaBD.nombreResponsable).append(", TRESP.");
		strSql.append(W83bRespAreaBD.perfilId).append(", TPERF.");
		strSql.append(W83bRespAreaBD.isPerfilCentrales).append(", TPERF.");
		strSql.append(W83bRespAreaBD.perfilDesc).append(", TPERF.");
		strSql.append(W83bRespAreaBD.perfilDescEus).append(", TRESP.");
		strSql.append(W83bRespAreaBD.sexo).append(", TRESP.");
		strSql.append(W83bRespAreaBD.baja);

		strSql.append(" FROM ").append(W83bRespAreaBD.respAreaTable).append(" TRESP");
		strSql.append(", ").append(W83bRespAreaBD.perfilTable).append(" TPERF");

		strSql.append(" WHERE TRESP.").append(W83bRespAreaBD.perfilId).append(" =  TPERF.").append(W83bRespAreaBD.codPerfil);
		strSql.append(" AND TRESP.").append(W83bRespAreaBD.codigoResponsable).append(" = ? ");
		params.add(new Integer(param.getCodigoResponsable()));

		List listaRespArea = W83bDataBase.executeQuery(strSql.toString(),params, W83bRespAreaBean.class, param.getUsuarioBean(), null);

		return (W83bRespAreaBean) listaRespArea.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#anyadirRespArea(w83b.w83bBeans.W83bRespAreaBean)
	 */
	public String anyadirRespArea(W83bRespAreaBean param) throws Exception {
		// sql para uno da alta

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bRespAreaBD.respAreaTable).append(" (");

		strSql.append(W83bRespAreaBD.codigoResponsable).append(", ");
		strSql.append(W83bRespAreaBD.territorio).append(", ");
		strSql.append(W83bRespAreaBD.nombreResponsable).append(", ");
		strSql.append(W83bRespAreaBD.sexo).append(", ");
		strSql.append(W83bRespAreaBD.perfilId).append(" )");

		strSql.append(" VALUES (?,?,?,?,?)");

		if (StringUtils.isNotEmpty(param.getCodigoResponsable())) {
			params.add(new Integer(param.getCodigoResponsable()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if (StringUtils.isNotEmpty(param.getTerritorio())) {
			params.add(param.getTerritorio().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getNombreResponsable())) {
			params.add(param.getNombreResponsable().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getSexoResponsable())) {
			params.add(param.getSexoResponsable().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getPerfilId())) {
			params.add(param.getPerfilId().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarRespArea(java.util.ArrayList,w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public String borrarRespArea(ArrayList param,W83bUsuarioXLNetsBean usuarioBean) throws Exception,RemoteException {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bRespAreaBD.respAreaTable);
		strSql.append(" SET ");
		strSql.append(W83bRespAreaBD.baja);

		strSql.append(" = to_Date(?,'DD/mm/YYYY') ");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		params.add(sdf.format(new Date()));
		strSql.append(" WHERE ");

		strSql.append(W83bRespAreaBD.codigoResponsable).append(" = ? ");
		params.add(new Integer((String) param.get(0)));
		for (int i = 1, size = param.size(); i < size; i++) {
			strSql.append(" OR ").append(W83bRespAreaBD.codigoResponsable).append(" = ? ");
			params.add((String) param.get(i));
		}

		W83bClsTrazas.traza(usuarioBean, "Quedando la SQL --> "+ strSql.toString());
		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#modificarRespArea(w83b.w83bBeans.W83bRespAreaBean)
	 */
	public String modificarRespArea(W83bRespAreaBean param) throws Exception {
		// sql para modificazcion de raspArea
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bRespAreaBD.respAreaTable);

		strSql.append(" SET ");

		strSql.append(W83bRespAreaBD.territorio);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bRespAreaBD.nombreResponsable);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bRespAreaBD.perfilId);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bRespAreaBD.sexo);
		strSql.append(" = ? ");
		if (StringUtils.isEmpty(param.getBaja())) {
			strSql.append(", ");
			strSql.append(W83bRespAreaBD.baja);
			strSql.append(" = ? ");
		}

		strSql.append(" WHERE ").append(W83bRespAreaBD.codigoResponsable).append(" = ? ");

		if (StringUtils.isNotEmpty(param.getTerritorio())) {
			params.add(param.getTerritorio().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getNombreResponsable())) {
			params.add(param.getNombreResponsable().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getPerfilId())) {
			params.add(param.getPerfilId().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getSexoResponsable())) {
			params.add(param.getSexoResponsable().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isEmpty(param.getBaja())) {
			params.add(W83bClsConstantes.NULL_DATE);
		}

		if (StringUtils.isNotEmpty(param.getTerritorio())) {

			params.add(new Integer(param.getCodigoResponsable()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#existeTerritorio(java.lang.String)
	 */
	public boolean existeTerritorio(String codResponsable) throws Exception {
		boolean encontrado = false;

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bRespAreaBD.codigoResponsable);

		strSql.append(" FROM ").append(W83bRespAreaBD.respAreaTable);

		strSql.append(" WHERE ").append(W83bRespAreaBD.codigoResponsable).append(" = ? ");
		params.add(new Integer(codResponsable));

		List listaRespArea = W83bDataBase.executeSimpleQuery(strSql.toString(),
				params, null);

		if (listaRespArea.size() > 0) {
			return encontrado = true;
		}

		return encontrado;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#existeProvinciaPerfil(java.lang.String, java.lang.String)
	 */
	public boolean existeProvinciaPerfil(String codTerritorio, String codPerfil)throws Exception {
		boolean encontrado = false;

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bRespAreaBD.codigoResponsable);

		strSql.append(" FROM ").append(W83bRespAreaBD.respAreaTable);

		strSql.append(" WHERE ").append(W83bRespAreaBD.territorio).append(" = ? ");
		params.add(new Integer(codTerritorio));
		strSql.append(" AND ").append(W83bRespAreaBD.perfilId).append(" = ? ");
		params.add(new Integer(codPerfil));
		strSql.append(" AND ").append(W83bRespAreaBD.baja).append(" IS NULL ");

		List listaRespArea = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		if (listaRespArea.size() > 0) {
			return encontrado = true;
		}

		return encontrado;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#existeProvinciaPerfil(java.lang.String, java.lang.String)
	 */
	public boolean existeProvinciaPerfilNoActual(String codTerritorio,String codPerfil, String codResponsable) throws Exception {
		boolean encontrado = false;

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bRespAreaBD.codigoResponsable);

		strSql.append(" FROM ").append(W83bRespAreaBD.respAreaTable);

		strSql.append(" WHERE ").append(W83bRespAreaBD.territorio).append(" = ? ");
		params.add(new Integer(codTerritorio));
		strSql.append(" AND ").append(W83bRespAreaBD.perfilId).append(" = ? ");
		params.add(new Integer(codPerfil));
		strSql.append(" AND ").append(W83bRespAreaBD.codigoResponsable).append(" <> ? ");
		params.add(new Integer(codResponsable));
		strSql.append(" AND ").append(W83bRespAreaBD.baja).append(" IS NULL ");

		List listaRespArea = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		if (listaRespArea.size() > 0) {
			return encontrado = true;
		}

		return encontrado;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#anyadirArbitro(w83b.w83bBeans.W83bArbitrosBean)
	 */
	public String anyadirArbitro(W83bArbitrosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bArbitrosBD.arbitrosTable).append(" (");

		strSql.append(W83bArbitrosBD.territorio).append(", ");
		strSql.append(W83bArbitrosBD.dni).append(", ");
		strSql.append(W83bArbitrosBD.nombreArbitro).append(" )");

		strSql.append(" VALUES (?,?,?)");

		if (StringUtils.isNotEmpty(param.getTerritorio())) {
			params.add(param.getTerritorio().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDni())) {
			params.add(param.getDni().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getNombreArbitro())) {
			params.add(param.getNombreArbitro().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}

		W83bClsTrazas.traza(param.getUsuarioBean(), "Quedando la SQL --> "+ strSql.toString());
		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarArbitro(java.util.ArrayList,w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public String borrarArbitro(ArrayList param,
			W83bUsuarioXLNetsBean usuarioBean) throws Exception,
			RemoteException {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bArbitrosBD.arbitrosTable);
		strSql.append(" SET ");
		strSql.append(W83bArbitrosBD.baja);

		strSql.append(" = to_Date(?,'DD/mm/YYYY') ");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		params.add(sdf.format(new Date()));
		strSql.append(" WHERE ");

		strSql.append(W83bArbitrosBD.dni).append(" = ? ");
		params.add(param.get(0));

		strSql.append(" AND ");
		strSql.append(W83bArbitrosBD.territorio).append(" = ? ");
		params.add(param.get(1));

		W83bClsTrazas.traza(usuarioBean, "Quedando la SQL --> "+ strSql.toString());
		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#buscarArbitros(w83b.w83bBeans.W83bArbitrosBean)
	 */
	public List buscarArbitros(W83bArbitrosBean param) throws Exception {
		// TODO Auto-generated method stub
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		// TODO hacer sqlquery!

		strSql.append("SELECT TARB.");
		strSql.append(W83bArbitrosBD.territorio).append(", TARB.");
		strSql.append(W83bArbitrosBD.dni).append(", TARB.");
		strSql.append(W83bArbitrosBD.nombreArbitro).append(", TARB.");
		strSql.append(W83bArbitrosBD.baja).append(", TPROV.");
		strSql.append(W83bArbitrosBD.descTablaTerritorio);

		strSql.append(" FROM ").append(W83bArbitrosBD.arbitrosTable).append(" TARB");
		strSql.append(", ").append(W83bArbitrosBD.arbitrosProvinciaTable).append(" TPROV");

		boolean where = true;
		strSql.append(" WHERE TARB.").append(W83bArbitrosBD.territorio).append(" = TPROV.").append(W83bArbitrosBD.idTablaTerritorio).append(" ");

		if (StringUtils.isNotEmpty(param.getTerritorio())) {
			strSql.append(" AND TARB.").append(W83bArbitrosBD.territorio).append(" = ? ");

			params.add(param.getTerritorio());
		}
		if (StringUtils.isNotEmpty(param.getDni())) {
			if (!where) {
				strSql.append(" WHERE ");
				where = true;
			} else {
				strSql.append(" AND ");
			}
			strSql.append(" UPPER(TARB.").append(W83bArbitrosBD.dni).append(") LIKE ? ");
			params.add("%" + param.getDni().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getNombreArbitro())) {
			if (!where) {
				strSql.append(" WHERE ");
				where = true;
			} else {
				strSql.append(" AND ");
			}
			strSql.append(" UPPER(TARB.").append(W83bArbitrosBD.nombreArbitro).append(") LIKE ? ");
			params.add("%" + param.getNombreArbitro().toUpperCase() + "%");
		}

		if (StringUtils.isNotEmpty(param.getBaja())) {
			if (!where) {
				strSql.append(" WHERE TARB.");
				where = true;
			} else {
				strSql.append(" AND TARB.");
			}
			strSql.append(W83bArbitrosBD.baja).append(" is not null");
		} else {
			if (!where) {
				strSql.append(" WHERE TARB.");
				where = true;
			} else {
				strSql.append(" AND TARB.");
			}
			strSql.append(W83bArbitrosBD.baja).append(" is null");
		}

		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());

		W83bClsTrazas.traza(param.getUsuarioBean(), "Quedando la SQL --> "+ strSql.toString());

		List listaRespArea = W83bDataBase.executeQuery(strSql.toString(),params, W83bArbitrosBean.class, param.getUsuarioBean(), null);

		return listaRespArea;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#detalleArbitro(w83b.w83bBeans.W83bArbitrosBean)
	 */
	public W83bArbitrosBean detalleArbitro(W83bArbitrosBean param)throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bArbitrosBD.territorio).append(", ");
		strSql.append(W83bArbitrosBD.dni).append(", ");
		strSql.append(W83bArbitrosBD.nombreArbitro).append(", ");
		strSql.append(W83bArbitrosBD.baja);

		strSql.append(" FROM ").append(W83bArbitrosBD.arbitrosTable);

		strSql.append(" WHERE ");
		strSql.append(W83bArbitrosBD.territorio).append(" = ? ");
		params.add(param.getTerritorio());
		strSql.append(" AND ");
		strSql.append(W83bArbitrosBD.dni).append(" = ? ");
		params.add(param.getDni());

		W83bClsTrazas.traza(param.getUsuarioBean(),"Quedando la SQL(detalle arbitro ) --> " + strSql.toString());
		List listaArbitros = W83bDataBase.executeQuery(strSql.toString(),params, W83bArbitrosBean.class, param.getUsuarioBean(), null);

		return (W83bArbitrosBean) listaArbitros.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#modificarArbitro(w83b.w83bBeans.W83bArbitrosBean, w83b.w83bBeans.W83bArbitrosBean)
	 */
	public String modificarArbitro(W83bArbitrosBean paramTemp,W83bArbitrosBean paramNuevo) throws Exception {
		// sql para modificazcion de arbitros
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bArbitrosBD.arbitrosTable);

		strSql.append(" SET ");

		strSql.append(W83bArbitrosBD.dni);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bArbitrosBD.nombreArbitro);
		strSql.append(" = ? ");
		if (StringUtils.isEmpty(paramNuevo.getBaja())) {
			strSql.append(", ");
			strSql.append(W83bArbitrosBD.baja);
			strSql.append(" = ? ");
		}

		strSql.append(" WHERE ").append(W83bArbitrosBD.territorio).append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bArbitrosBD.dni).append(" = ? ");

		if (StringUtils.isNotEmpty(paramNuevo.getDni())) {
			params.add(paramNuevo.getDni().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(paramNuevo.getNombreArbitro())) {
			params.add(paramNuevo.getNombreArbitro().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isEmpty(paramNuevo.getBaja())) {
			params.add(W83bClsConstantes.NULL_DATE);
		}
		if (StringUtils.isNotEmpty(paramTemp.getTerritorio())) {
			params.add(paramTemp.getTerritorio().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(paramTemp.getDni())) {
			params.add(paramTemp.getDni().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}

		W83bClsTrazas.traza(paramNuevo.getUsuarioBean(), "SQL --> "+ strSql.toString());
		W83bDataBase.executeTableMovement(strSql.toString(), params, paramNuevo.getUsuarioBean());

		return "0";

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#existeArbitro(w83b.w83bBeans.W83bArbitrosBean)
	 */
	public boolean existeArbitro(W83bArbitrosBean param) throws Exception {

		boolean encontrado = false;

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bArbitrosBD.territorio);

		strSql.append(" FROM ").append(W83bArbitrosBD.arbitrosTable);

		strSql.append(" WHERE ").append(W83bArbitrosBD.territorio).append(" = ? ");
		params.add(param.getTerritorio());
		strSql.append(" AND ");
		strSql.append(W83bArbitrosBD.dni).append(" = ? ");
		params.add(param.getDni());
		List listaArbitros = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		if (listaArbitros.size() > 0) {
			return encontrado = true;
		}

		return encontrado;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#existeDni(w83b.w83bBeans.W83bArbitrosBean)
	 */
	public boolean existeDni(W83bArbitrosBean paramTemp) throws Exception {
		boolean encontrado = false;

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bArbitrosBD.dni);

		strSql.append(" FROM ").append(W83bArbitrosBD.arbitrosTable);

		strSql.append(" WHERE ").append(W83bArbitrosBD.dni).append(" = ? ");
		params.add(paramTemp.getDni().toUpperCase());

		List listaArbitros = W83bDataBase.executeQuery(strSql.toString(),params, W83bArbitrosBean.class, null, null);

		if (listaArbitros.size() > 0) {
			return encontrado = true;
		}

		return encontrado;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarAgrupaciones(java.util.ArrayList)
	 */
	public java.lang.String borrarEmpresas(String param,
			W83bUsuarioXLNetsBean usuarioBean) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bTipoEmpresaBD.tipoEmpresaTable);
		strSql.append(" SET ");
		strSql.append(W83bTipoEmpresaBD.baja);
		strSql.append(" = to_Date(?,'DD/mm/YYYY') ");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		params.add(sdf.format(new Date()));
		strSql.append(" WHERE ");

		strSql.append(W83bTipoEmpresaBD.codigo).append(" = ? ");
		params.add(new Integer(param));
		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/**
	 * Existe motivo acta.
	 * 
	 * @param idMotivo the id motivo
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeMotivoActa(String idMotivo) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bActasBD.numActa);

		strSql.append(" FROM ").append(W83bActasBD.actasTable);

		strSql.append(" WHERE ").append(W83bActasBD.codMotivosBaja).append(" = ? ");
		params.add(new Integer(idMotivo));

		List listaMotivos = W83bDataBase.executeSimpleQuery(strSql.toString(),
				params, null);

		if (listaMotivos.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarMotivoActa(java.util.ArrayList,w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public java.lang.String borrarMotivoActa(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bMotivosBajaActaBD.motivosBajaVista);
		strSql.append(" SET ");
		strSql.append(W83bMotivosBajaActaBD.baja);
		strSql.append(" = to_Date(?,'DD/mm/YYYY') ");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		params.add(sdf.format(new Date()));
		strSql.append(" WHERE ");

		strSql.append(W83bMotivosBajaActaBD.codMotivo).append(" = ? ");
		params.add(new Integer((String) param.get(0)));
		for (int i = 1, size = param.size(); i < size; i++) {
			strSql.append(" OR ").append(W83bMotivosBajaActaBD.codMotivo).append(" = ? ");
			params.add(new Integer((String) param.get(i)));// NOPMD
		}

		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/**
	 * Existe motivo delegado.
	 * 
	 * @param idMotivo the id motivo
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeMotivoDelegado(String idMotivo,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		// IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(usuarioBean.getIdUsuario());

		strSql.append("SELECT ");
		strSql.append(W83bDelegadosBD.dni);

		strSql.append(" FROM ").append(W83bDelegadosBD.delegadosVista);

		strSql.append(" WHERE ").append(W83bDelegadosBD.baja).append(" = ? ");
		params.add(new Integer(idMotivo));

		List listaMotivos = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		// TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();

		if (listaMotivos.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarMotivoDelegado(java.util.ArrayList, w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public java.lang.String borrarMotivoDelegado(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bMotivosBajaDelegadoBD.motivosBajaVista);
		strSql.append(" SET ");
		strSql.append(W83bMotivosBajaDelegadoBD.baja);
		strSql.append(" = to_Date(?,'DD/mm/YYYY') ");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		params.add(sdf.format(new Date()));

		strSql.append(" WHERE ");

		strSql.append(W83bMotivosBajaDelegadoBD.codMotivo).append(" = ? ");
		params.add(new Integer((String) param.get(0)));
		for (int i = 1, size = param.size(); i < size; i++) {
			strSql.append(" OR ").append(W83bMotivosBajaDelegadoBD.codMotivo).append(" = ? ");
			params.add(new Integer((String) param.get(i)));// NOPMD
		}

		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/**
	 * Existe sindicato asociacion.
	 * 
	 * @param idSindicato the id sindicato
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeSindicatoAsociacion(String idSindicato,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bDiferenciasBD.acta);

		strSql.append(" FROM ").append(W83bDiferenciasBD.difVista);

		strSql.append(" WHERE ").append(W83bDiferenciasBD.codSind).append(
				" = ? ");
		params.add(new Integer(idSindicato));

		List listaDiferencias = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bEscrutiniosBD.acta);

		strSql.append(" FROM ").append(W83bEscrutiniosBD.escrutVista);

		strSql.append(" WHERE ").append(W83bEscrutiniosBD.codSind).append(" = ? ");
		params.add(new Integer(idSindicato));

		List listaEscrutinios = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		params = new ArrayList();

		// IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(usuarioBean.getIdUsuario());

		strSql.append("SELECT ");
		strSql.append(W83bDelegadosBD.dni);

		strSql.append(" FROM ").append(W83bDelegadosBD.delegadosVista);

		strSql.append(" WHERE ").append(W83bDelegadosBD.codSindicato).append(" = ? ");
		params.add(new Integer(idSindicato));

		List listaDelegados = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		// TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();

		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bSindicatosPreavisosBD.preaviso);

		strSql.append(" FROM ").append(W83bSindicatosPreavisosBD.sindPreVista);

		strSql.append(" WHERE ").append(W83bSindicatosPreavisosBD.codSind).append(" = ? ");
		params.add(new Integer(idSindicato));

		List listaSindPre = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bImpugnacionesSindicatosBD.impugnacion);

		strSql.append(" FROM ").append(
				W83bImpugnacionesSindicatosBD.impSindVista);

		strSql.append(" WHERE ").append(W83bImpugnacionesSindicatosBD.codSind).append(" = ? ");
		params.add(new Integer(idSindicato));

		List listaImpSind = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bSindPreOrigBD.preaviso);

		strSql.append(" FROM ").append(W83bSindPreOrigBD.sindPreOrigVista);

		strSql.append(" WHERE ").append(W83bSindPreOrigBD.codSind).append(" = ? ");
		params.add(new Integer(idSindicato));

		List listaSindPreOrig = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bSindCitacionesBD.preaviso);

		strSql.append(" FROM ").append(W83bSindCitacionesBD.sindPreOrigVista);

		strSql.append(" WHERE ").append(W83bSindCitacionesBD.codSind).append(" = ? ");
		params.add(new Integer(idSindicato));

		List listaSindCitaciones = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaDiferencias.size() > 0 || listaEscrutinios.size() > 0
				|| listaDelegados.size() > 0 || listaSindPre.size() > 0
				|| listaImpSind.size() > 0 || listaSindPreOrig.size() > 0
				|| listaSindCitaciones.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#buscarTiposVoces(w83b.w83bBeans.W83bTiposVocesBean)
	 */
	public java.util.List buscarTiposVoces(w83b.w83bBeans.W83bTiposVocesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		// defino la sentencia SQL
		strSql.append("SELECT TO_NUMBER(TTIPOVOZ.");
		// los atributos que me interesan
		strSql.append(W83bTiposVocesBD.codigo).append("), TTIPOVOZ.");
		strSql.append(W83bTiposVocesBD.descripcion).append(", TTIPOVOZ.");
		strSql.append(W83bTiposVocesBD.descripcion_eusk).append(", TTIPOVOZ.");
		strSql.append(W83bTiposVocesBD.codigo).append(", TTIPOVOZ.");
		strSql.append(W83bTiposVocesBD.baja);

		strSql.append(" FROM ").append(W83bTiposVocesBD.tiposVocesTable).append(" TTIPOVOZ");
		strSql.append(" WHERE ").append(W83bTiposVocesBD.codigo).append(" > 0 ");

		if (StringUtils.isNotEmpty(param.getCodTipoVoz())) {
			strSql.append(" AND ").append(W83bTiposVocesBD.codigo).append(" = ? ");
			params.add(new Integer(param.getCodTipoVoz()));
		}
		if (StringUtils.isNotEmpty(param.getDescTipoVoz())) {
			strSql.append(" AND UPPER(").append(W83bTiposVocesBD.descripcion).append(") LIKE ? ");
			params.add("%" + param.getDescTipoVoz().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getDescTipoVozEusk())) {
			strSql.append(" AND UPPER(").append(W83bTiposVocesBD.descripcion_eusk).append(") LIKE ? ");
			params.add("%" + param.getDescTipoVozEusk().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getBaja())) {
			strSql.append(" AND ").append(W83bTiposVocesBD.baja).append(" IS NOT NULL ");
		} else {
			strSql.append(" AND ").append(W83bTiposVocesBD.baja).append(" IS NULL ");
		}
		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());

		List listaTiposVoces = W83bDataBase.executeQuery(strSql.toString(),params, W83bTiposVocesBean.class, null, param.getIdioma());

		return listaTiposVoces;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#detalleTiposVoces(w83b.w83bBeans.W83bTiposVocesBean)
	 */
	public w83b.w83bBeans.W83bTiposVocesBean detalleTiposVoces(w83b.w83bBeans.W83bTiposVocesBean param) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT TTiposVoces.");
		strSql.append(W83bTiposVocesBD.codigo).append(", TTiposVoces.");
		strSql.append(W83bTiposVocesBD.descripcion).append(", TTiposVoces.");
		strSql.append(W83bTiposVocesBD.descripcion_eusk).append(", TTiposVoces.");
		strSql.append(W83bTiposVocesBD.baja);

		strSql.append(" FROM ").append(W83bTiposVocesBD.tiposVocesTable).append(" TTiposVoces");
		;

		strSql.append(" WHERE TTiposVoces.");
		strSql.append(W83bTiposVocesBD.codigo).append(" = ? ");

		params.add(new Integer(param.getCodTipoVoz()));

		List listaTiposVoces = W83bDataBase.executeQuery(strSql.toString(),params, W83bTiposVocesBean.class, null, null);

		return (W83bTiposVocesBean) listaTiposVoces.get(0);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarTiposVoces(java.util.ArrayList,w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public java.lang.String borrarTiposVoces(java.util.ArrayList param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bTiposVocesBD.tiposVocesTable);
		strSql.append(" SET ");
		strSql.append(W83bTiposVocesBD.baja);

		strSql.append(" = to_Date(?,'DD/mm/YYYY') ");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		params.add(sdf.format(new Date()));
		strSql.append(" WHERE ");

		strSql.append(W83bTiposVocesBD.codigo).append(" IN (");

		for (int i = 0; i < param.size(); i++) {
			if (i > 0) {
				strSql.append(",");
			}
			strSql.append("?");
			params.add(param.get(i));
		}

		strSql.append(")");

		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#maxCodTiposVoces()
	 */
	public String maxCodTiposVoces() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT	NVL (MAX (to_number(");
		strSql.append(W83bTiposVocesBD.codigo);
		strSql.append(")), 0)");
		strSql.append("FROM ");
		strSql.append(W83bTiposVocesBD.tiposVocesTable);

		List listaTiposVoces = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		return listaTiposVoces.get(0).toString();
	}

	/**
	 * Existe empresa convenio.
	 * 
	 * @param idEmpresa the id empresa
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeEmpresaConvenio(String idEmpresa) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bConveniosBD.codigo);

		strSql.append(" FROM ").append(W83bConveniosBD.convenioTable);

		strSql.append(" WHERE ").append(W83bConveniosBD.tipoEmpresa).append(" = ? ");
		params.add(new Integer(idEmpresa));

		List listaConvenios = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaConvenios.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#anyadirTiposVoces(w83b.w83bBeans.W83bTiposVocesBean)
	 */
	public String anyadirTiposVoces(W83bTiposVocesBean param) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bTiposVocesBD.tiposVocesTable);

		strSql.append(" VALUES (?,?,?,?)");
		params.add(new Integer(param.getCodTipoVoz()));

		if (StringUtils.isNotEmpty(param.getDescTipoVoz())) {
			params.add(param.getDescTipoVoz().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescTipoVozEusk())) {
			params.add(param.getDescTipoVozEusk().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(W83bClsConstantes.NULL_DATE);

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/**
	 * Existe tipos voces.
	 * 
	 * @param param the param
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeTiposVoces(String param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bTiposVocesBD.codigo);

		strSql.append(" FROM ").append(W83bTiposVocesBD.tiposVocesTable);

		strSql.append(" WHERE ").append(W83bTiposVocesBD.codigo).append(" = ? ");
		params.add(new Integer(param));

		List listaTiposVoces = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaTiposVoces.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#modificarTiposVoces(w83b.w83bBeans.W83bTiposVocesBean)
	 */
	public String modificarTiposVoces(W83bTiposVocesBean param)throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bTiposVocesBD.tiposVocesTable);
		strSql.append(" SET ");
		strSql.append(W83bTiposVocesBD.descripcion);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bTiposVocesBD.descripcion_eusk);
		strSql.append(" = ? ");
		if (StringUtils.isEmpty(param.getBaja())) {
			strSql.append(", ");
			strSql.append(W83bTiposVocesBD.baja);
			strSql.append(" = ? ");
		}

		strSql.append(" WHERE ").append(W83bTiposVocesBD.codigo).append(" = ? ");

		if (StringUtils.isNotEmpty(param.getDescTipoVoz())) {
			params.add(param.getDescTipoVoz().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescTipoVozEusk())) {
			params.add(param.getDescTipoVozEusk().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isEmpty(param.getBaja())) {
			params.add(W83bClsConstantes.NULL_STRING);
		}

		params.add(new Integer(param.getCodTipoVoz()));

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#contarTiposVoces()
	 */
	public String contarTiposVoces() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT COUNT(");
		strSql.append(W83bTiposVocesBD.codigo);

		strSql.append(") FROM ").append(W83bTiposVocesBD.tiposVocesTable);

		List listaTiposVoces = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		return listaTiposVoces.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarVoces(w83b.w83bBeans.W83bVocesBean)
	 */
	public List buscarVoces(W83bVocesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		// defino la sentencia SQL
		strSql.append("SELECT TVOZ.");
		// los atributos que me interesan
		strSql.append(W83bVocesBD.codigoTipoVoz).append(", TTIPOVOCES.");
		strSql.append(W83bTiposVocesBD.descripcion).append(", TTIPOVOCES.");
		strSql.append(W83bTiposVocesBD.descripcion_eusk).append(", TVOZ.");
		strSql.append(W83bVocesBD.codigo).append(", TVOZ.");
		strSql.append(W83bVocesBD.descripcion).append(", TVOZ.");
		strSql.append(W83bVocesBD.descripcion_eusk).append(", TVOZ.");
		strSql.append(W83bVocesBD.baja);

		strSql.append(" FROM ").append(W83bVocesBD.vocesTable).append(" TVOZ");
		strSql.append(", ").append(W83bTiposVocesBD.tiposVocesTable).append(" TTIPOVOCES");

		strSql.append(" WHERE ").append(W83bVocesBD.codigo).append(" > 0 ");
		strSql.append(" AND ").append(W83bVocesBD.codigoTipoVoz).append(" > 0 ");

		if (StringUtils.isNotEmpty(param.getCodTipoVoz())) {
			strSql.append(" AND ").append(W83bVocesBD.codigoTipoVoz).append(" = ? ");
			params.add(new Integer(param.getCodTipoVoz()));
		}
		if (StringUtils.isNotEmpty(param.getCodVoz())) {
			strSql.append(" AND ").append(W83bVocesBD.codigo).append(" = ? ");
			params.add(new Integer(param.getCodVoz()));
		}
		if (StringUtils.isNotEmpty(param.getDescVoz())) {
			strSql.append(" AND UPPER(").append(W83bVocesBD.descripcion).append(") LIKE ? ");
			params.add("%" + param.getDescVoz().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getDescVozEusk())) {
			strSql.append(" AND UPPER(").append(W83bVocesBD.descripcion_eusk).append(") LIKE ? ");
			params.add("%" + param.getDescVozEusk().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getBaja())) {
			strSql.append(" AND ").append(W83bVocesBD.baja).append(" IS NOT NULL ");
		} else {
			strSql.append(" AND ").append(W83bVocesBD.baja).append(" IS NULL ");
		}
		strSql.append(" AND TTIPOVOCES.").append(W83bTiposVocesBD.codigo).append(" = TVOZ.");
		strSql.append(W83bVocesBD.codigoTipoVoz);

		if (param.getIdColumna().equals("1")) {
			strSql.append(" ORDER BY TO_NUMBER(").append(W83bVocesBD.codigo).append(") ").append(param.getSort()).append(" , TO_NUMBER(").append(W83bVocesBD.codigoTipoVoz).append(") ").append(param.getSort());
		} else if (param.getIdColumna().equals("2")) {
			strSql.append(" ORDER BY TO_NUMBER(").append(W83bVocesBD.codigoTipoVoz).append(") ").append(param.getSort()).append(" , TO_NUMBER(").append(W83bVocesBD.codigo).append(") ").append(param.getSort());
		} else if (param.getIdColumna().equals("3")) {
			strSql.append(" ORDER BY ").append(W83bVocesBD.descripcion).append(" ").append(param.getSort()).append(" , TO_NUMBER(").append(W83bVocesBD.codigoTipoVoz).append(") ").append(param.getSort());
		} else if (param.getIdColumna().equals("3")) {
			strSql.append(" ORDER BY ").append(W83bVocesBD.descripcion_eusk).append(" ").append(param.getSort()).append(" , TO_NUMBER(").append(W83bVocesBD.codigoTipoVoz).append(") ").append(param.getSort());
		} else {
			strSql.append(" ORDER BY TO_NUMBER(").append(W83bVocesBD.codigoTipoVoz).append(") ").append(param.getSort()).append(" , TO_NUMBER(").append(W83bVocesBD.codigo).append(") ").append(param.getSort());
		}

		List listaVoces = W83bDataBase.executeQuery(strSql.toString(), params,W83bVocesBean.class, param.getUsuarioBean(), param.getIdioma());

		return listaVoces;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#anyadirVoces(w83b.w83bBeans.W83bVocesBean)
	 */
	public String anyadirVoces(W83bVocesBean param) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bVocesBD.vocesTable);

		strSql.append(" VALUES (?,?,?,?,?)");
		params.add(new Integer(param.getCodVoz()));
		params.add(new Integer(param.getCodTipoVoz()));

		if (StringUtils.isNotEmpty(param.getDescVoz())) {
			params.add(param.getDescVoz().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescVozEusk())) {
			params.add(param.getDescVozEusk().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(W83bClsConstantes.NULL_DATE);

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#existeVoces(java.lang.String,java.lang.String)
	 */
	public boolean existeVoces(String codVoz, String codTipoVoz)throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT TVoces.");
		strSql.append(W83bVocesBD.codigo).append(", TVoces.");
		strSql.append(W83bVocesBD.codigoTipoVoz);

		strSql.append(" FROM ").append(W83bVocesBD.vocesTable).append(" TVoces");

		strSql.append(" WHERE ").append(W83bVocesBD.codigo).append(" = ? ");
		strSql.append(" AND ").append(W83bVocesBD.codigoTipoVoz).append(" = ? ");
		params.add(new Integer(codVoz));
		params.add(new Integer(codTipoVoz));

		List listaTiposVoces = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaTiposVoces.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#modificarVoces(w83b.w83bBeans.W83bVocesBean)
	 */
	public String modificarVoces(W83bVocesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bVocesBD.vocesTable);
		strSql.append(" SET ");
		strSql.append(W83bVocesBD.descripcion);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bVocesBD.descripcion_eusk);
		strSql.append(" = ? ");
		if (StringUtils.isEmpty(param.getBaja())) {
			strSql.append(", ");
			strSql.append(W83bVocesBD.baja);
			strSql.append(" = ? ");
		}

		strSql.append(" WHERE ").append(W83bVocesBD.codigo).append(" = ? ");
		strSql.append(" AND ").append(W83bVocesBD.codigoTipoVoz).append(" = ? ");

		if (StringUtils.isNotEmpty(param.getDescVoz())) {
			params.add(param.getDescVoz().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescVozEusk())) {
			params.add(param.getDescVozEusk().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isEmpty(param.getBaja())) {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(new Integer(param.getCodVoz()));
		params.add(new Integer(param.getCodTipoVoz()));

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#maxCodVoces(java.lang.String)
	 */
	public String maxCodVoces(String param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT	NVL (MAX (to_number(");
		strSql.append(W83bVocesBD.codigo);
		strSql.append(")), 0)");
		strSql.append("FROM ");
		strSql.append(W83bVocesBD.vocesTable).append(" TVoces");
		strSql.append(" WHERE TVoces.");
		strSql.append(W83bVocesBD.codigoTipoVoz).append(" = ? ");
		params.add(new Integer(param));

		List listaVoces = W83bDataBase.executeSimpleQuery(strSql.toString(),params, null);

		return listaVoces.get(0).toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#detalleVoces(w83b.w83bBeans.W83bVocesBean)
	 */
	public W83bVocesBean detalleVoces(W83bVocesBean param) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT TVoces.");
		strSql.append(W83bVocesBD.codigo).append(", TVoces.");
		strSql.append(W83bVocesBD.codigoTipoVoz).append(", TVoces.");
		strSql.append(W83bVocesBD.descripcion).append(", TVoces.");
		strSql.append(W83bVocesBD.descripcion_eusk).append(", TVoces.");
		strSql.append(W83bVocesBD.baja);

		strSql.append(" FROM ").append(W83bVocesBD.vocesTable).append(" TVoces");

		strSql.append(" WHERE TVoces.");
		strSql.append(W83bVocesBD.codigo).append(" = ? ");
		strSql.append(" AND TVoces.").append(W83bVocesBD.codigoTipoVoz).append(" = ? ");

		params.add(new Integer(param.getCodVoz()));
		params.add(new Integer(param.getCodTipoVoz()));

		List listaVoces = W83bDataBase.executeQuery(strSql.toString(), params,W83bVocesBean.class, null, null);

		return (W83bVocesBean) listaVoces.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#borrarVoces(java.util.ArrayList,w83b.w83bBeans.W83bUsuarioXLNetsBean)
	 */
	public String borrarVoces(ArrayList param, W83bUsuarioXLNetsBean usuarioBean)
			throws Exception, RemoteException {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bVocesBD.vocesTable);
		strSql.append(" SET ");
		strSql.append(W83bVocesBD.baja);
		strSql.append(" = to_Date(?,'DD/mm/YYYY') ");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		params.add(sdf.format(new Date()));

		strSql.append(" WHERE ");

		strSql.append(W83bVocesBD.codigo).append(" = ? ");
		params.add(param.get(0));

		strSql.append(" AND ");
		strSql.append(W83bVocesBD.codigoTipoVoz).append(" = ? ");
		params.add(param.get(1));

		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarDelegaciones(w83b.w83bBeans.W83bDelegacionesBean)
	 */
	public List buscarDelegaciones(W83bDelegacionesBean param) throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		// defino la sentencia SQL
		strSql.append("SELECT TDELE.");
		// los atributos que me interesan
		strSql.append(W83bDelegacionesBD.codTerritorio).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.codServCent).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.calle).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.numero).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.piso).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.letra).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.codPostal).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.localidad).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.telefono1).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.telefono2).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.fax).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.numModelo).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.numModeloSalida).append(", TDELE.");
		strSql.append(W83bDelegacionesBD.registroEntrada).append(", TMUN.");
		strSql.append(W83bMunicipiosBD.nomMunic_Cast).append(", TMUN.");
		strSql.append(W83bMunicipiosBD.codProvincia).append(", TMUN.");
		strSql.append(W83bMunicipiosBD.codMunic).append(", TPROV.");
		strSql.append(W83bProvinciasBD.codProvinc).append(", TPROV.");
		strSql.append(W83bProvinciasBD.nomProvinc_Cast).append(" AS ").append("NOMBREPROVINCIA ");

		strSql.append(" FROM ").append(W83bDelegacionesBD.delegacionesView).append(" TDELE");
		strSql.append(", ").append(W83bMunicipiosBD.municipiosTable).append(" TMUN");
		strSql.append(", ").append(W83bProvinciasBD.provinciasTable).append(" TPROV");

		strSql.append(" WHERE ").append(W83bDelegacionesBD.codTerritorio).append(" > 0 ");
		strSql.append(" AND TMUN.").append(W83bMunicipiosBD.codMunic).append(" > 0 ");

		strSql.append(" AND TO_CHAR(TMUN.").append(W83bMunicipiosBD.codProvincia).append(") LIKE TO_CHAR(TDELE.").append(W83bDelegacionesBD.codServCent).append(" )");
		strSql.append(" AND TO_CHAR(TMUN.").append(W83bMunicipiosBD.codMunic).append(") LIKE TO_CHAR(TDELE.").append(W83bDelegacionesBD.localidad).append(" )");
		strSql.append(" AND TO_CHAR(TPROV.").append(W83bProvinciasBD.codProvinc).append(") LIKE TO_CHAR(TDELE.").append(W83bDelegacionesBD.codServCent).append(" )");
		if (StringUtils.isNotEmpty(param.getCodTerritorio())) {
			strSql.append(" AND ").append(W83bDelegacionesBD.codTerritorio).append(" = ? ");
			params.add(param.getCodTerritorio());
		}
		if (StringUtils.isNotEmpty(param.getLocalidad())) {
			strSql.append(" AND ").append(W83bDelegacionesBD.localidad).append(" = ? ");
			params.add(param.getLocalidad());
		}
		if (StringUtils.isNotEmpty(param.getCalle())) {
			strSql.append(" AND UPPER(").append(W83bDelegacionesBD.calle).append(") LIKE ? ");
			params.add("%" + param.getCalle().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getNumero())) {
			strSql.append(" AND ").append(W83bDelegacionesBD.numero).append(" = ? ");
			params.add(new Integer(param.getNumero()));
		}
		if (StringUtils.isNotEmpty(param.getPiso())) {
			strSql.append(" AND ").append(W83bDelegacionesBD.piso).append(" = ? ");
			params.add(new Integer(param.getPiso()));
		}
		if (StringUtils.isNotEmpty(param.getLetra())) {
			strSql.append(" AND UPPER(").append(W83bDelegacionesBD.letra).append(") LIKE ? ");
			params.add("%" + param.getLetra().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getCodPostal())) {
			strSql.append(" AND UPPER(").append(W83bDelegacionesBD.codPostal).append(") LIKE ? ");
			params.add("%" + param.getCodPostal().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getTelefono1())) {
			strSql.append(" AND ").append(W83bDelegacionesBD.telefono1).append(" = ? ");
			params.add(new Integer(param.getTelefono1()));
		}
		if (StringUtils.isNotEmpty(param.getTelefono2())) {
			strSql.append(" AND ").append(W83bDelegacionesBD.telefono2).append(" = ? ");
			params.add(new Integer(param.getTelefono2()));
		}
		if (StringUtils.isNotEmpty(param.getFax())) {
			strSql.append(" AND ").append(W83bDelegacionesBD.fax).append(" = ? ");
			params.add(new Integer(param.getFax()));
		}
		if (StringUtils.isNotEmpty(param.getNumModelo())) {
			strSql.append(" AND ").append(W83bDelegacionesBD.numModelo).append(" = ? ");
			params.add(new Integer(param.getNumModelo()));
		}
		if (StringUtils.isNotEmpty(param.getNumModeloSalida())) {
			strSql.append(" AND ").append(W83bDelegacionesBD.numModeloSalida).append(" = ? ");
			params.add(new Integer(param.getNumModeloSalida()));
		}
		if (StringUtils.isNotEmpty(param.getRegistroEntrada())&& W83bClsConstantes.CONSTANTE_NO.equals(param.getRegistroEntrada())) {
			strSql.append(" AND ").append(W83bDelegacionesBD.registroEntrada).append(" LIKE ? ");
			params.add("%1%");
		} else if (StringUtils.isNotEmpty(param.getRegistroEntrada())&& W83bClsConstantes.CONSTANTE_SI.equals(param.getRegistroEntrada())) {
			strSql.append(" AND ").append(W83bDelegacionesBD.registroEntrada).append(" LIKE ? ");
			params.add("%0%");
		} else {
			strSql.append(" AND (").append(W83bDelegacionesBD.registroEntrada).append(" LIKE ? ");
			strSql.append(" OR ").append(W83bDelegacionesBD.registroEntrada).append(" LIKE ? )");
			params.add("%0%");
			params.add("%1%");
		}

		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());

		List listaDel = W83bDataBase.executeQuery(strSql.toString(), params,W83bDelegacionesBean.class, param.getUsuarioBean(), param.getIdioma());

		return listaDel;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#detalleDelegaciones(w83b.w83bBeans.W83bDelegacionesBean)
	 */
	public W83bDelegacionesBean detalleDelegaciones(W83bDelegacionesBean param)throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT TDEL.");
		strSql.append(W83bDelegacionesBD.codTerritorio).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.codServCent).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.calle).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.numero).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.piso).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.letra).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.codPostal).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.localidad).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.telefono1).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.telefono2).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.fax).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.numModelo).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.numModeloSalida).append(", TDEL.");
		strSql.append(W83bDelegacionesBD.registroEntrada).append(", TMUN.");
		strSql.append(W83bMunicipiosBD.nomMunic_Cast).append(", TMUN.");
		strSql.append(W83bMunicipiosBD.codProvincia).append(", TMUN.");
		strSql.append(W83bMunicipiosBD.codMunic);

		strSql.append(" FROM ").append(W83bDelegacionesBD.delegacionesView).append(" TDEL");
		strSql.append(", ").append(W83bMunicipiosBD.municipiosTable).append(" TMUN");

		strSql.append(" WHERE TDEL.");
		strSql.append(W83bDelegacionesBD.codTerritorio).append(" = ? ");
		params.add(new Integer(param.getCodTerritorio()));
		strSql.append(" AND TO_CHAR(TMUN.").append(W83bMunicipiosBD.codProvincia).append(") LIKE TO_CHAR(TDEL.").append(W83bDelegacionesBD.codServCent).append(" )");
		strSql.append(" AND TO_CHAR(TMUN.").append(W83bMunicipiosBD.codMunic).append(") LIKE TO_CHAR(TDEL.").append(W83bDelegacionesBD.localidad).append(" )");

		List listaDelegaciones = W83bDataBase.executeQuery(strSql.toString(),params, W83bDelegacionesBean.class, null, null);

		return (W83bDelegacionesBean) listaDelegaciones.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#anyadirDelegaciones(w83b.w83bBeans.W83bDelegacionesBean)
	 */
	public String anyadirDelegaciones(W83bDelegacionesBean param)throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("INSERT INTO ");
		strSql.append(W83bDelegacionesBD.delegacionesView);

		strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
		params.add(param.getCodTerritorio());
		// telefono 1
		params.add(new Integer(param.getTelefono1()));
		// telefono 2
		if (StringUtils.isNotEmpty(param.getTelefono2())) {
			params.add(new Integer(param.getTelefono2()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		// fax
		if (StringUtils.isNotEmpty(param.getFax())) {
			params.add(new Integer(param.getFax()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}

		// calle
		params.add(param.getCalle().toUpperCase());
		// numero
		params.add(new Integer(param.getNumero()));
		// piso
		if (StringUtils.isNotEmpty(param.getPiso())) {
			params.add(new Integer(param.getPiso()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		// letra
		if (StringUtils.isNotEmpty(param.getLetra())) {
			params.add(param.getLetra().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		// CP
		params.add(param.getCodPostal().toUpperCase());
		// Localidad
		params.add(param.getLocalidad().toUpperCase());
		// Registro manual
		if (StringUtils.isEmpty(param.getRegistroEntrada())) {
			params.add("0");
		} else {
			params.add("1");
		}
		if (StringUtils.isNotEmpty(param.getNumModelo())) {
			params.add(new Integer(param.getNumModelo()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if (StringUtils.isNotEmpty(param.getNumModeloSalida())) {
			params.add(new Integer(param.getNumModeloSalida()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		params.add(param.getCodServCent());

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#existeDelegaciones(java.lang.String)
	 */
	public boolean existeDelegaciones(String codDelegacion) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bDelegacionesBD.codTerritorio);

		strSql.append(" FROM ").append(W83bDelegacionesBD.delegacionesView);

		strSql.append(" WHERE ").append(W83bDelegacionesBD.codTerritorio).append(" = ? ");
		params.add(new Integer(codDelegacion));

		List listaDelegaciones = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		if (listaDelegaciones.size() > 0) {
			return true;
		}

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#modificarDelegaciones(w83b.w83bBeans.W83bDelegacionesBean)
	 */
	public String modificarDelegaciones(W83bDelegacionesBean param)throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bDelegacionesBD.delegacionesView);
		strSql.append(" SET ");
		strSql.append(W83bDelegacionesBD.codServCent);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bDelegacionesBD.calle);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bDelegacionesBD.numero);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bDelegacionesBD.piso);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bDelegacionesBD.letra);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bDelegacionesBD.codPostal);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bDelegacionesBD.localidad);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bDelegacionesBD.telefono1);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bDelegacionesBD.telefono2);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bDelegacionesBD.fax);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bDelegacionesBD.numModelo);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bDelegacionesBD.numModeloSalida);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bDelegacionesBD.registroEntrada);
		strSql.append(" = ? ");

		strSql.append(" WHERE ").append(W83bDelegacionesBD.codTerritorio).append(" = ? ");

		params.add(param.getCodServCent());
		params.add(param.getCalle().toUpperCase());
		params.add(new Integer(param.getNumero()));
		if (StringUtils.isNotEmpty(param.getPiso())) {
			params.add(new Integer(param.getPiso()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if (StringUtils.isNotEmpty(param.getLetra())) {
			params.add(param.getLetra().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		params.add(param.getCodPostal().toUpperCase());
		params.add(param.getLocalidad().toUpperCase());
		params.add(new Integer(param.getTelefono1()));
		if (StringUtils.isNotEmpty(param.getTelefono2())) {
			params.add(new Integer(param.getTelefono2()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if (StringUtils.isNotEmpty(param.getFax())) {
			params.add(new Integer(param.getFax()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if (StringUtils.isNotEmpty(param.getNumModelo())) {
			params.add(new Integer(param.getNumModelo()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if (StringUtils.isNotEmpty(param.getNumModeloSalida())) {
			params.add(new Integer(param.getNumModeloSalida()));
		} else {
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if ((W83bClsConstantes.ZERO + "").equals(param.getRegistroEntrada())) {
			params.add(W83bClsConstantes.ZERO + "");
		} else if ((W83bClsConstantes.UNO + "").equals(param.getRegistroEntrada())) {
			params.add(W83bClsConstantes.UNO + "");
		} else {
			params.add(W83bClsConstantes.ZERO + "");
		}

		params.add(new Integer(param.getCodTerritorio()));

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#buscarTramites(w83b.w83bBeans.W83bTramitesBean)
	 */
	public List buscarTramites(W83bTramitesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		// defino la sentencia SQL
		strSql.append("SELECT TTRAMITE.");
		// los atributos que me interesan
		strSql.append(W83bTramitesBD.codTramite).append(", TTRAMITE.");
		strSql.append(W83bTramitesBD.codFase).append(", TFASE.");
		strSql.append(W83bFasesBD.descripcion).append(", TFASE.");
		strSql.append(W83bFasesBD.descripcion_eusk).append(", TTRAMITE.");
		strSql.append(W83bTramitesBD.nomTramite_Cast).append(", TTRAMITE.");
		strSql.append(W83bTramitesBD.nomTramite_Eusk);

		strSql.append(" FROM ").append(W83bTramitesBD.tramitesTable).append(" TTRAMITE");
		strSql.append(", ").append(W83bFasesBD.fasesTable).append(" TFASE");

		strSql.append(" WHERE ").append(W83bTramitesBD.codTramite).append(" > 0 ");
		strSql.append(" AND ").append(W83bTramitesBD.codFase).append(" > 0 ");

		if (StringUtils.isNotEmpty(param.getCodFase())) {
			strSql.append(" AND ").append(W83bTramitesBD.codFase).append(" = ? ");
			params.add(new Integer(param.getCodFase()));
		}
		if (StringUtils.isNotEmpty(param.getCodTramite())) {
			strSql.append(" AND ").append(W83bTramitesBD.codTramite).append(" = ? ");
			params.add(new Integer(param.getCodTramite()));
		}
		if (StringUtils.isNotEmpty(param.getDescTramite())) {
			strSql.append(" AND UPPER(").append(W83bTramitesBD.nomTramite_Cast).append(") LIKE ? ");
			params.add("%" + param.getDescTramite().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getDescTramiteEusk())) {
			strSql.append(" AND UPPER(").append(W83bTramitesBD.nomTramite_Eusk).append(") LIKE ? ");
			params.add("%" + param.getDescTramiteEusk().toUpperCase() + "%");
		}
		strSql.append(" AND TFASE.").append(W83bFasesBD.codigo).append(" = TTRAMITE.");
		strSql.append(W83bTramitesBD.codFase);

		String col = param.getIdColumna();
		if ("1".equals(col)) {
			strSql.append(" ORDER BY ").append(W83bTramitesBD.codigo).append(" ").append(param.getSort()).append(", ").append(W83bTramitesBD.codFase).append(" ").append(param.getSort());
		} else if ("2".equals(col)) {
			strSql.append(" ORDER BY ").append(W83bTramitesBD.codFase).append(" ").append(param.getSort()).append(", ").append(W83bTramitesBD.codigo).append(" ").append(param.getSort());
		} else if ("3".equals(col)) {
			strSql.append(" ORDER BY ").append(W83bTramitesBD.descripcion).append(" ").append(param.getSort());
		} else if ("4".equals(col)) {
			strSql.append(" ORDER BY ").append(W83bTramitesBD.descripcion_eusk).append(" ").append(param.getSort());
		}

		List listaTramites = W83bDataBase.executeQuery(strSql.toString(),params, W83bTramitesBean.class, param.getUsuarioBean(), param.getIdioma());

		return listaTramites;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#modificarTramites(w83b.w83bBeans.W83bTramitesBean)
	 */
	public String modificarTramites(W83bTramitesBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bTramitesBD.tramitesTable);
		strSql.append(" SET ");
		strSql.append(W83bTramitesBD.nomTramite_Cast);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bTramitesBD.nomTramite_Eusk);
		strSql.append(" = ? ");

		strSql.append(" WHERE ").append(W83bTramitesBD.codTramite).append(" = ? ");
		strSql.append(" AND ").append(W83bTramitesBD.codFase).append(" = ? ");

		if (StringUtils.isNotEmpty(param.getDescTramite())) {
			params.add(param.getDescTramite().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescTramiteEusk())) {
			params.add(param.getDescTramiteEusk().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}

		params.add(new Integer(param.getCodTramite()));
		params.add(new Integer(param.getCodFase()));

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#detalleTramites(w83b.w83bBeans.W83bTramitesBean)
	 */
	public W83bTramitesBean detalleTramites(W83bTramitesBean param)throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT TTRAMITES.");
		strSql.append(W83bTramitesBD.codTramite).append(", TTRAMITES.");
		strSql.append(W83bTramitesBD.codFase).append(", TTRAMITES.");
		strSql.append(W83bTramitesBD.nomTramite_Cast).append(", TTRAMITES.");
		strSql.append(W83bTramitesBD.nomTramite_Eusk);

		strSql.append(" FROM ").append(W83bTramitesBD.tramitesTable).append(" TTRAMITES");

		strSql.append(" WHERE TTRAMITES.");
		strSql.append(W83bTramitesBD.codTramite).append(" = ? ");
		strSql.append(" AND TTRAMITES.").append(W83bTramitesBD.codFase).append(" = ? ");

		params.add(new Integer(param.getCodTramite()));
		params.add(new Integer(param.getCodFase()));

		List listaTramites = W83bDataBase.executeQuery(strSql.toString(),params, W83bTramitesBean.class, null, null);

		return (W83bTramitesBean) listaTramites.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#buscarPlantillas(w83b.w83bBeans.W83bPlantillasBean)
	 */
	public List buscarPlantillas(W83bPlantillasBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		// defino la sentencia SQL
		strSql.append("SELECT TPLANT.");
		// los atributos que me interesan
		strSql.append(W83bPlantillasBD.idPlantilla).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.idTramite).append(", TTRAM.");
		strSql.append(W83bTramitesBD.descripcion).append(", TTRAM.");
		strSql.append(W83bTramitesBD.descripcion_eusk).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.idFase).append(", TFASES.");
		strSql.append(W83bFasesBD.descripcion).append(", TFASES.");
		strSql.append(W83bFasesBD.descripcion_eusk).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.nombrePlantilla).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.descripcion).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.descripcion_eusk).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.fichero);

		strSql.append(" FROM ").append(W83bPlantillasBD.plantillasTable).append(" TPLANT");
		strSql.append(", ").append(W83bTramitesBD.tramitesTable).append(" TTRAM");
		strSql.append(", ").append(W83bFasesBD.fasesTable).append(" TFASES");

		strSql.append(" WHERE ").append(W83bPlantillasBD.idPlantilla).append(" > 0 ");
		strSql.append(" AND ").append(W83bTramitesBD.codigo).append(" > 0 ");
		strSql.append(" AND ").append(W83bFasesBD.codigo).append(" > 0 ");

		if (StringUtils.isNotEmpty(param.getNombrePlantilla())) {
			strSql.append(" AND UPPER(TPLANT.").append(W83bPlantillasBD.nombrePlantilla).append(") LIKE ? ");
			params.add("%" + param.getNombrePlantilla().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getIdTramite())) {
			strSql.append(" AND TPLANT.").append(W83bPlantillasBD.idTramite).append(" = ? ");
			params.add(new Integer(param.getIdTramite()));
		}
		if (StringUtils.isNotEmpty(param.getIdFase())) {
			strSql.append(" AND TPLANT.").append(W83bPlantillasBD.idFase).append(" = ? ");
			params.add(new Integer(param.getIdFase()));
		}
		if (StringUtils.isNotEmpty(param.getDescripcion())) {
			strSql.append(" AND UPPER(TPLANT.").append(W83bPlantillasBD.descripcion).append(") LIKE ? ");
			params.add("%" + param.getDescripcion().toUpperCase() + "%");
		}
		if (StringUtils.isNotEmpty(param.getDescripcion_eusk())) {
			strSql.append(" AND UPPER(TPLANT.").append(W83bPlantillasBD.descripcion_eusk).append(") LIKE ? ");
			params.add("%" + param.getDescripcion_eusk().toUpperCase() + "%");
		}
		strSql.append(" AND TTRAM.").append(W83bTramitesBD.codigo).append(" = TPLANT.");
		strSql.append(W83bPlantillasBD.idTramite);
		strSql.append(" AND TFASES.").append(W83bFasesBD.codigo).append(" = TPLANT.");
		strSql.append(W83bPlantillasBD.idFase);
		strSql.append(" AND TFASES.").append(W83bFasesBD.codigo).append(" = TTRAM.");
		strSql.append(W83bTramitesBD.codFase);

		if (param.getIdColumna().equalsIgnoreCase("1")) {
			strSql.append(" ORDER BY ").append(W83bPlantillasBD.nombrePlantilla).append(" ").append(param.getSort());
		} else if (param.getIdColumna().equalsIgnoreCase("2")) {
			strSql.append(" ORDER BY ").append(W83bTramitesBD.descripcion).append(" ").append(param.getSort());
		} else if (param.getIdColumna().equalsIgnoreCase("3")) {
			strSql.append(" ORDER BY ").append(W83bFasesBD.descripcion).append(" ").append(param.getSort());
		} else if (param.getIdColumna().equalsIgnoreCase("4")) {
			if (param.getIdioma().equalsIgnoreCase("es")) {
				strSql.append(" ORDER BY ").append(W83bPlantillasBD.descripcion).append(" ").append(param.getSort());
			} else {
				strSql.append(" ORDER BY ").append(W83bPlantillasBD.descripcion_eusk).append(" ").append(param.getSort());
			}
		} else {
			strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());
		}

		return W83bDataBase.executeQuery(strSql.toString(), params,W83bPlantillasBean.class, param.getUsuarioBean(), param.getIdioma());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seew83b.w83bDAO.W83bIMantenimientosDAO#buscarPlantillas(w83b.w83bBeans.W83bPlantillasBean)
	 */
	public HashMap buscarPlantillas(List nombres) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		// defino la sentencia SQL
		strSql.append("SELECT TPLANT.");
		// los atributos que me interesan
		strSql.append(W83bPlantillasBD.idPlantilla).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.idTramite).append(", TTRAM.");
		strSql.append(W83bTramitesBD.descripcion).append(", TTRAM.");
		strSql.append(W83bTramitesBD.descripcion_eusk).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.idFase).append(", TFASES.");
		strSql.append(W83bFasesBD.descripcion).append(", TFASES.");
		strSql.append(W83bFasesBD.descripcion_eusk).append(", UPPER(TPLANT.");
		strSql.append(W83bPlantillasBD.nombrePlantilla).append(") as ").append(W83bPlantillasBD.nombrePlantilla);
		strSql.append(", TPLANT.");
		strSql.append(W83bPlantillasBD.descripcion).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.descripcion_eusk).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.fichero);

		strSql.append(" FROM ").append(W83bPlantillasBD.plantillasTable).append(" TPLANT");
		strSql.append(", ").append(W83bTramitesBD.tramitesTable).append(" TTRAM");
		strSql.append(", ").append(W83bFasesBD.fasesTable).append(" TFASES");

		strSql.append(" WHERE ").append(W83bPlantillasBD.idPlantilla).append(" > 0 ");
		strSql.append(" AND ").append(W83bTramitesBD.codigo).append(" > 0 ");
		strSql.append(" AND ").append(W83bFasesBD.codigo).append(" > 0 ");

		if (nombres != null && nombres.size() > 0) {
			strSql.append(" AND UPPER(TPLANT.").append(W83bPlantillasBD.nombrePlantilla).append(") IN ( ");
			for (int i = 0; i < nombres.size(); i++) {
				if (i > 0) {
					strSql.append(", ");
				}
				strSql.append("? ");
				params.add(((String) nombres.get(i)).toUpperCase());
			}
			strSql.append(" )");

		}

		strSql.append(" AND TTRAM.").append(W83bTramitesBD.codigo).append(" = TPLANT.");
		strSql.append(W83bPlantillasBD.idTramite);
		strSql.append(" AND TFASES.").append(W83bFasesBD.codigo).append(" = TPLANT.");
		strSql.append(W83bPlantillasBD.idFase);
		strSql.append(" AND TFASES.").append(W83bFasesBD.codigo).append(" = TTRAM.");
		strSql.append(W83bTramitesBD.codFase);

		// strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());

		return W83bDataBase.executeQueryHashMap(strSql.toString(), params,
				W83bPlantillasBean.class, null, null, "nombrePlantilla");

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * w83b.w83bDAO.W83bIMantenimientosDAO#detallePlantillas(w83b.w83bBeans.
	 * W83bPlantillasBean)
	 */
	public W83bPlantillasBean detallePlantillas(W83bPlantillasBean param)
			throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT TPLANT.");
		strSql.append(W83bPlantillasBD.nombrePlantilla).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.idPlantilla).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.idFase).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.idTramite).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.descripcion).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.descripcion_eusk).append(", TPLANT.");
		strSql.append(W83bPlantillasBD.fichero);

		strSql.append(" FROM ").append(W83bPlantillasBD.plantillasTable).append(" TPLANT");

		strSql.append(" WHERE TPLANT.");
		strSql.append(W83bPlantillasBD.idPlantilla).append(" = ? ");
		strSql.append(" AND TPLANT.").append(W83bPlantillasBD.idFase).append(" = ? ");
		strSql.append(" AND TPLANT.").append(W83bPlantillasBD.idTramite).append(" = ? ");

		params.add(new Integer(param.getIdPlantilla()));
		params.add(new Integer(param.getIdFase()));
		params.add(new Integer(param.getIdTramite()));

		List listaPlantillas = W83bDataBase.executeQuery(strSql.toString(),params, W83bPlantillasBean.class, null, null);
		return (W83bPlantillasBean) listaPlantillas.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#modificarPlantillas(w83b.w83bBeans.W83bPlantillasBean)
	 */
	public String modificarPlantillas(W83bPlantillasBean param)
			throws Exception {

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		byte[] fichero = (byte[]) param.getFichero();

		strSql.append("UPDATE ");
		strSql.append(W83bPlantillasBD.plantillasTable);
		strSql.append(" SET ");
		strSql.append(W83bPlantillasBD.nombrePlantilla);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bPlantillasBD.descripcion);
		strSql.append(" = ? ");
		strSql.append(", ");
		strSql.append(W83bPlantillasBD.descripcion_eusk);
		strSql.append(" = ? ");
		if (fichero.length != 0) {
			strSql.append(", ");
			strSql.append(W83bPlantillasBD.fichero);
			strSql.append(" = ? ");
		}

		strSql.append(" WHERE ").append(W83bPlantillasBD.idPlantilla).append(" = ? ");
		strSql.append(" AND ").append(W83bPlantillasBD.idFase).append(" = ? ");
		strSql.append(" AND ").append(W83bPlantillasBD.idTramite).append(" = ? ");

		if (StringUtils.isNotEmpty(param.getNombrePlantilla())) {
			params.add(param.getNombrePlantilla().toUpperCase());
		}
		if (StringUtils.isNotEmpty(param.getDescripcion())) {
			params.add(param.getDescripcion().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getDescripcion_eusk())) {
			params.add(param.getDescripcion_eusk().toUpperCase());
		} else {
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (fichero.length != 0) {
			params.add(fichero);
		}

		params.add(new Integer(param.getIdPlantilla()));
		params.add(new Integer(param.getIdFase()));
		params.add(new Integer(param.getIdTramite()));

		W83bDataBase.executeTableMovement(strSql.toString(), params, param.getUsuarioBean());

		return "0";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#contarResponsablesArea()
	 */
	public String contarResponsablesArea() throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT	NVL (MAX (to_number(");
		strSql.append(W83bRespAreaBD.codigoResponsable);
		strSql.append(")), 0)");
		strSql.append("FROM ");
		strSql.append(W83bRespAreaBD.respAreaTable);

		List listaResponsables = W83bDataBase.executeSimpleQuery(strSql.toString(), params, null);

		return listaResponsables.get(0).toString();
	}

	public List buscarDelegados(W83bMantenimientoDelegadosBean param)throws Exception {
		//W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean) param.getUsuarioBean();
		//String provinciaUsuario = "";
		/*if (usuario != null) {
			provinciaUsuario = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());
		}*/
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT TDEL.");
		strSql.append(W83bActasBD.num_acta_comp).append(", TDEL.");
		strSql.append(W83bActasBD.codTerritActa).append(", TDEL.");
		strSql.append(W83bActasBD.anyoActa).append(", TDEL.");
		strSql.append(W83bActasBD.numActa).append(", TDEL.");
		strSql.append(W83bActasBD.versionActa).append(", ");
		strSql.append("TO_CHAR(TDEL.").append(W83bActasBD.fechaBaja).append(",?) AS ").append(W83bActasBD.fechaBaja).append(" , TDEL.");
		strSql.append(W83bDelegadosBD.nombre).append(", TDEL.");
		strSql.append(W83bDelegadosBD.apellido1).append(", TDEL.");
		strSql.append(W83bDelegadosBD.apellido2).append(", TDEL.");
		strSql.append(W83bDelegadosBD.dni).append(", ");
		strSql.append("TO_CHAR(TDEL.").append(W83bDelegadosBD.fechaBaja).append(",?) AS ").append(W83bDelegadosBD.fechaBaja).append(" , TDEL.");
		strSql.append(W83bDelegadosBD.codSindicato).append(", TDEL.");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.razonSocial).append(", TDEL.");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.telefono).append(", TDEL.");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.cifNif).append(", TDEL.");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.domicilio).append(", TDEL.");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.fax).append(", TDEL.");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codMunicipio).append(", TDEL.");
		strSql.append(W83bCentroTrabajoCompletoVistaBD.codTerritorio).append(", TDEL.");
		strSql.append(W83bDelegadosBD.descMunicipio).append(", TDEL.");
		strSql.append(W83bDelegadosBD.descTerritorio);

		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));

		strSql.append(" FROM ").append(W83bDelegadosBD.mantenimientoDelegados).append(" TDEL");
		strSql.append(" WHERE ").append(W83bActasBD.numActa).append(" > 0 ");

		if ((W83bClsConstantes.DOS + "").equalsIgnoreCase(param.getCodBaja())) {
			strSql.append(" AND TDEL.").append(W83bDelegadosBD.fechaBaja).append(" IS NOT NULL ");
		} else if ((W83bClsConstantes.UNO + "").equalsIgnoreCase(param.getCodBaja())) {
			strSql.append(" AND TDEL.").append(W83bDelegadosBD.fechaBaja).append(" IS NULL ");
		}

		if (StringUtils.isNotEmpty(param.getFechaBajaDesde())) {
			strSql.append(" AND TDEL.");
			strSql.append(W83bDelegadosBD.fechaBaja).append(" >= ").append("TO_DATE(?,?)");
			params.add(param.getFechaBajaDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if (StringUtils.isNotEmpty(param.getFechaBajaHasta())) {
			strSql.append(" AND TDEL.");
			strSql.append(W83bDelegadosBD.fechaBaja).append(" <= ").append("TO_DATE(?,?)");
			params.add(param.getFechaBajaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}

		if (StringUtils.isNotEmpty(param.getIdProvincia())) {
			strSql.append(" AND TDEL.");
			strSql.append(W83bCentroTrabajoCompletoVistaBD.codTerritorio).append(" = ? ");
			params.add(param.getIdProvincia());
			// Antonio 08/05/2013
			// }else{
			// strSql.append(" AND TDEL.");
			// strSql.append(W83bCentroTrabajoCompletoVistaBD.codTerritorio).append(" = ? ");
			// if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provinciaUsuario)){
			// params.add(W83bClsConstantes.CONSTANTE_ALAVA);
			// }else
			// if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provinciaUsuario)){
			// params.add(W83bClsConstantes.CONSTANTE_ALAVA);
			// }else
			// if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provinciaUsuario)){
			// params.add(W83bClsConstantes.CONSTANTE_BIZKAIA);
			// }else
			// if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provinciaUsuario)){
			// params.add(W83bClsConstantes.CONSTANTE_GIPUZKOA);
			// }

		}

		if (StringUtils.isNotEmpty(param.getIdMunicipio())) {
			strSql.append(" AND TDEL.");
			strSql.append(W83bCentroTrabajoCompletoVistaBD.codMunicipio).append(" = ? ");
			params.add(param.getIdMunicipio());
			// Antonio 08/05/2013
			// }else{
			// strSql.append(" AND TDEL.");
			// strSql.append(W83bCentroTrabajoCompletoVistaBD.codMunicipio).append(" = ? ");
			// if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provinciaUsuario)){
			// params.add(W83bClsConstantes.CONSTANTE_VITORIA);
			// }else
			// if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provinciaUsuario)){
			// params.add(W83bClsConstantes.CONSTANTE_VITORIA);
			// }else
			// if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provinciaUsuario)){
			// params.add(W83bClsConstantes.CONSTANTE_BILBAO);
			// }else
			// if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provinciaUsuario)){
			// params.add(W83bClsConstantes.CONSTANTE_DONOSTIA);
			// }

		}

		if (StringUtils.isNotEmpty(param.getDniDelegado())) {
			strSql.append(" AND TDEL.");
			strSql.append(W83bDelegadosBD.dni).append(" LIKE ? ");
			params.add(param.getDniDelegado());
		}

		if (StringUtils.isNotEmpty(param.getNombreDelegado())) {
			strSql.append(" AND TDEL.");
			strSql.append(W83bDelegadosBD.nombre).append(" LIKE ? ");
			params.add("%" + param.getNombreDelegado() + "%");
		}

		if (StringUtils.isNotEmpty(param.getPrimerApellidoDelegado())) {
			strSql.append(" AND TDEL.");
			strSql.append(W83bDelegadosBD.apellido1).append(" LIKE ? ");
			params.add("%" + param.getPrimerApellidoDelegado() + "%");
		}

		if (StringUtils.isNotEmpty(param.getSegundoApellidoDelegado())) {
			strSql.append(" AND TDEL.");
			strSql.append(W83bDelegadosBD.apellido2).append(" LIKE ? ");
			params.add("%" + param.getSegundoApellidoDelegado() + "%");
		}
		if ((W83bClsConstantes.UNO + "").equals(param.getIdColumna())) {
			strSql.append(" ORDER BY ").append(W83bActasBD.codTerritActa).append(", ").append(W83bActasBD.anyoActa).append(", ").append(W83bActasBD.numActa).append(", ").append(W83bActasBD.versionActa).append(", ").append(W83bDelegadosBD.dni);
		} else {
			strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());
		}
		List listaDelegados = W83bDataBase.executeQuery(strSql.toString(),params, W83bMantenimientoDelegadosBean.class, null, null);

		return listaDelegados;
	}

}